/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.common.model;

import java.io.Serializable;
import oracle.bpm.lang.Str;
import oracle.bpm.services.common.model.CompositeDNModel;
import org.jetbrains.annotations.NotNull;

public class ComponentDNModel
implements Serializable,
Comparable<ComponentDNModel> {
    private String componentDNString;
    private String componentName;
    private CompositeDNModel compositeDN;
    private static final long serialVersionUID = 5910240142761381566L;

    private ComponentDNModel() {
    }

    public static ComponentDNModel buildComponentDN(@NotNull String applicationName, @NotNull String compositeName, @NotNull String revision, @NotNull String label, @NotNull String componentName) {
        CompositeDNModel compositeDNModel = CompositeDNModel.buildCompositeDN(applicationName, compositeName, revision, label);
        return ComponentDNModel.buildComponentDN(compositeDNModel, componentName);
    }

    public static ComponentDNModel buildComponentDN(@NotNull String compositeDN, @NotNull String componentName) {
        CompositeDNModel compositeDNModel = CompositeDNModel.parseCompositeDN(compositeDN);
        return ComponentDNModel.buildComponentDN(compositeDNModel, componentName);
    }

    public static ComponentDNModel buildComponentDN(@NotNull CompositeDNModel compositeDNModel, @NotNull String componentName) {
        ComponentDNModel instance = new ComponentDNModel();
        instance.compositeDN = compositeDNModel;
        instance.componentName = componentName;
        instance.componentDNString = ComponentDNModel.buildComponentDNString(instance.compositeDN, instance.componentName);
        return instance;
    }

    public static ComponentDNModel parseComponentDN(String componentDN) {
        String[] parts = CompositeDNModel.compositeDLPattern.split(componentDN);
        if (parts.length != 3) {
            throw new IllegalArgumentException(componentDN);
        }
        String compositeDN = parts[0] + '/' + parts[1];
        String componentName = parts[2];
        return ComponentDNModel.buildComponentDN(compositeDN, componentName);
    }

    public static ComponentDNModel parseConsolidatedComponentDN(String consolidatedComponentDN) {
        String[] parts = CompositeDNModel.compositeDLPattern.split(consolidatedComponentDN);
        if (parts.length != 3) {
            throw new IllegalArgumentException(consolidatedComponentDN);
        }
        String compositeDN = parts[0] + '/' + parts[1];
        String componentName = parts[2];
        return ComponentDNModel.buildComponentDN(CompositeDNModel.parseConsolidatedCompositeDN(compositeDN), componentName);
    }

    public CompositeDNModel getCompositeDN() {
        return this.compositeDN;
    }

    public ComponentDNModel getComponentRevisionDN() {
        return Str.isEmpty((String)this.getCompositeDN().getLabel()) ? this : this.buildComponentRevisionDN();
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getDNString() {
        return this.componentDNString;
    }

    public String getConsolidatedDNString() {
        return this.compositeDN.getConsolidatedDNString() + '/' + this.getComponentName();
    }

    public String toString() {
        return this.getDNString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComponentDNModel)) {
            return false;
        }
        ComponentDNModel that = (ComponentDNModel)o;
        return this.getDNString().equals(that.getDNString());
    }

    public int hashCode() {
        return this.getDNString().hashCode();
    }

    @Override
    public int compareTo(ComponentDNModel componentDN) {
        if (componentDN == null) {
            return 1;
        }
        int compare = this.compositeDN.compareTo(componentDN.getCompositeDN());
        return compare != 0 ? compare : this.compareComponentName(componentDN.getComponentName());
    }

    public int compareWithoutLabelTo(ComponentDNModel componentDN) {
        if (componentDN == null) {
            return 1;
        }
        int compare = this.compositeDN.compareWithoutLabelTo(componentDN.getCompositeDN());
        return compare != 0 ? compare : this.compareComponentName(componentDN.getComponentName());
    }

    public int compareConsolidatedDNTo(ComponentDNModel componentDN) {
        if (componentDN == null) {
            return 1;
        }
        int compare = this.compositeDN.compareConsolidatedDNTo(componentDN.getCompositeDN());
        return compare != 0 ? compare : this.compareComponentName(componentDN.getComponentName());
    }

    private static String buildComponentDNString(CompositeDNModel compositeDNModel, String componentName) {
        return compositeDNModel.getDNString() + '/' + componentName;
    }

    private ComponentDNModel buildComponentRevisionDN() {
        return ComponentDNModel.buildComponentDN(this.compositeDN.getApplicationName(), this.compositeDN.getCompositeName(), this.compositeDN.getRevision(), "", this.componentName);
    }

    private int compareComponentName(String _componentName) {
        if (this.componentName != null && _componentName != null) {
            return this.componentName.compareTo(_componentName);
        }
        return this.componentName == null ? (_componentName == null ? 0 : -1) : 1;
    }
}

