/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.services.common;

import java.util.StringTokenizer;
import oracle.bpel.services.workflow.task.model.IdentityType;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpm.services.organization.model.ApplicationRoleType;

public class BPMServicesUtil {
    private static final String ESCALATIONPATH_DELIM = ":";

    public static IdentityType parseIdentityString(String value) {
        IdentityType identityType = null;
        if (value == null || value.trim().length() == 0) {
            return identityType;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, ESCALATIONPATH_DELIM, false);
        if (tokenizer.countTokens() != 2) {
            return identityType;
        }
        identityType = new ObjectFactory().createIdentityType();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token != null && !token.equals("") && tokenizer.hasMoreTokens()) {
                if (token.equals("APPROLE")) {
                    identityType.setType("application_role");
                    continue;
                }
                if (token.equals("GROUP")) {
                    identityType.setType("group");
                    continue;
                }
                if (token.equals("USER")) {
                    identityType.setType("user");
                    continue;
                }
                return null;
            }
            if (token != null && !token.equals("")) {
                identityType.setId(token);
                continue;
            }
            return null;
        }
        return identityType;
    }

    public static String formatIdentityValue(IdentityType identityType) {
        if (identityType == null || BPMServicesUtil.isStringNull(identityType.getId()) || BPMServicesUtil.isStringNull(identityType.getType())) {
            return null;
        }
        String type = null;
        StringBuilder builder = new StringBuilder();
        if ("application_role".equals(identityType.getType()) || "APPROLE".equals(identityType.getType())) {
            type = "APPROLE";
        }
        if ("user".equals(identityType.getType()) || "USER".equals(identityType.getType())) {
            type = "USER";
        }
        if ("group".equals(identityType.getType()) || "GROUP".equals(identityType.getType())) {
            type = "GROUP";
        }
        if (type != null) {
            builder.append(type).append(ESCALATIONPATH_DELIM).append(identityType.getId());
        }
        return builder.toString();
    }

    public static String getRoleId(ApplicationRoleType appRole) {
        if (appRole != null) {
            return appRole.getId() != null ? appRole.getId() : appRole.getName();
        }
        return null;
    }

    private static boolean isStringNull(String str) {
        return str == null || str.trim().isEmpty();
    }
}

