/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.workflow.editor.org;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdeveloper.server.connection.AppServer;
import oracle.jdeveloper.server.connection.AppServerManager;
import oracle.rc.asadapter.connection.AppServerConnection;
import oracle.rc.asadapter.connection.AppServerProvider;
import oracle.rc.asadapter.connection.ConnectionDescriptor;
import oracle.rc.asadapter.weblogic.connection.Weblogic10Descriptor;
import oracle.tip.tools.ide.common.services.connections.Connection;
import oracle.tip.tools.ide.common.services.connections.ConnectionsPanel;
import oracle.tip.tools.ide.common.services.connections.EditConnectionAction;
import oracle.tip.tools.ide.common.services.connections.IConnectionProvider;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;
import oracle.tip.tools.ide.workflow.editor.org.OrganizationsDetailPanel;
import oracle.tip.tools.ide.workflow.util.WorkflowResourceUtil;

public class ConnectionComponent
extends JPanel {
    protected JButton mEdit;
    protected Project mProject;
    protected JComboBox mServers;
    private Container container;
    private CardPanel mBGPanel;
    private LocalItemListener mItemListener = new LocalItemListener();
    private JLabel mLabel = null;
    private OrganizationsDetailPanel mListenerPanel;
    private LocalComboBoxModel mServerModel;
    public static final String SERVER_CHANGED = "SERVER_CHANGED";
    public static final String APP_SERVER_SELECTED = "APP_SERVER_SELECTED";
    private static final String APPLICATION_SERVER = "Application Server: ";
    private static final String LONG_STRING = "ApplicationServer That is Not Visible Completely Yet.";
    private static final String LOADING_DATA = WorkflowResourceUtil.getString((String)"LOADING_DATA");
    private static final String PLEASE_WAIT = WorkflowResourceUtil.getString((String)"PLEASE_WAIT");

    public ConnectionComponent(Project project, OrganizationsDetailPanel pListenerPanel, Container container) {
        this.mProject = project;
        this.mListenerPanel = pListenerPanel;
        this.container = container;
        this.initialize();
        this.layoutComponents();
    }

    public static void main(String[] argv) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setContentPane((Container)new ConnectionsPanel(null));
        f.setSize(600, 400);
        f.setVisible(true);
    }

    public JLabel getLabel() {
        return this.mLabel;
    }

    public Connection getSelectedConnection() {
        Connection connection = (Connection)this.mServers.getSelectedItem();
        return connection;
    }

    private void initialize() {
        this.mServerModel = new LocalComboBoxModel();
        this.mBGPanel = new CardPanel();
        this.mServers = new JComboBox(this.mServerModel);
        ConnectionPropertyChangeListener pcl = new ConnectionPropertyChangeListener();
        EditConnectionAction editAction = new EditConnectionAction((IConnectionProvider)new LocalConnectionProvider());
        editAction.addPropertyChangeListener((PropertyChangeListener)pcl);
        this.mEdit = new JButton((Action)editAction);
        UIHelper.setupButton((JButton)this.mEdit);
        this.mServers.setRenderer(new LocalServerRenderer());
        this.mServers.setPrototypeDisplayValue(LONG_STRING);
        this.mServerModel.addListDataListener(new LocalListDataListener());
        this.mServers.addItemListener(this.mItemListener);
        this.mLabel = new JLabel();
        this.mEdit.setEnabled(false);
        this.initializeServers();
    }

    private void layoutComponents() {
        this.removeAll();
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        int x = 0;
        int y = 0;
        JPanel panel = this.preparePanels();
        gbl.setConstraints(panel, new GridBagConstraints(x, y, 0, 0, 1.0, 1.0, 21, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.add(panel);
    }

    private JPanel prepareTopPanel() {
        JPanel panel = new JPanel();
        int x = 0;
        int y = 0;
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        ResourceUtils.resLabel((JLabel)this.mLabel, (Component)this.mServers, (String)APPLICATION_SERVER);
        gbl.setConstraints(this.mLabel, new GridBagConstraints(x, y, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(this.mLabel);
        gbl.setConstraints(this.mServers, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add(this.mServers);
        gbl.setConstraints(this.mEdit, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add(this.mEdit);
        Component c = Box.createHorizontalGlue();
        gbl.setConstraints(c, new GridBagConstraints(++x, y, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(c);
        return panel;
    }

    private JPanel preparePanels() {
        JPanel panel = new JPanel();
        JPanel top = this.prepareTopPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        int x = 0;
        int y = 0;
        gbl.setConstraints(top, new GridBagConstraints(x, y, 0, -1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add(top);
        gbl.setConstraints((Component)this.mBGPanel, new GridBagConstraints(x, ++y, 0, 0, 1.0, 1.0, 21, 1, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)this.mBGPanel);
        return panel;
    }

    private void reloadConnection(Connection pConnection, AppServer pServer) {
        Connection connection = (Connection)this.mServerModel.getSelectedItem();
        assert (connection.equals(pConnection));
        connection.update(pServer);
        this.mServerModel.update(connection);
    }

    private void rebuildList(AppServer server) {
        this.mServers.removeItemListener(this.mItemListener);
        Connection c = new Connection(server);
        this.mServerModel.addElement(c);
        this.mServers.setSelectedItem(c);
        this.mServers.addItemListener(this.mItemListener);
        this.fireSelectionOccurred();
    }

    private Collection<Connection> getConnections() {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        List appServers = AppServerManager.getInstance().list();
        for (String name : appServers) {
            AppServer ap = AppServerManager.getInstance().getAppServer(name);
            AppServerConnection connection = ap.getConnection();
            Platform p = ap.getPlatform();
            PlatformType ptype = p.getType();
            if (!PlatformType.WEBLOGIC.equals((Object)ptype)) continue;
            Weblogic10Descriptor desc = (Weblogic10Descriptor)ConnectionDescriptor.newInstance(Weblogic10Descriptor.class, (AppServerProvider)connection.getAppServerProvider());
            Connection newConnNode = new Connection();
            newConnNode.setName(name);
            newConnNode.setDescriptor(desc);
            connections.add(newConnNode);
        }
        return connections;
    }

    private void initializeServers() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.mServers.getModel();
        this.mServers.removeItemListener(this.mItemListener);
        model.removeAllElements();
        Connection c1 = new Connection();
        c1.setName("foo");
        Connection c2 = new Connection();
        c2.setName("bar");
        Collection<Connection> c = this.getConnections();
        for (Connection connection : c) {
            model.addElement(connection);
        }
        this.mServers.addItemListener(this.mItemListener);
        this.applicationServerChanged();
    }

    private void fireSelectionOccurred() {
        Connection connection = (Connection)this.mServers.getSelectedItem();
        this.mListenerPanel.initializeAttributeCombo(connection);
    }

    private void _applicationServerChanged() {
        Connection server = (Connection)this.mServers.getSelectedItem();
        this.mListenerPanel.initializeAttributeCombo(server);
    }

    private void applicationServerChanged() {
        final StatusGlassPane status = new StatusGlassPane((Component)this.container);
        status.enableUserInput(false);
        status.setStatusMessage(PLEASE_WAIT, LOADING_DATA);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ConnectionComponent.this._applicationServerChanged();
                }
                finally {
                    status.enableUserInput(true);
                }
            }
        };
        new Thread(r).start();
    }

    private class LocalServerRenderer
    extends DefaultListCellRenderer {
        private LocalServerRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Connection) {
                Connection c = (Connection)value;
                this.setText(c.getName());
            }
            return this;
        }
    }

    private class LocalListDataListener
    implements ListDataListener {
        private LocalListDataListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            int size = ConnectionComponent.this.mServerModel.getSize();
            ConnectionComponent.this.mEdit.setEnabled(size > 0);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    }

    private class LocalItemListener
    implements ItemListener {
        private LocalItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent pEvent) {
            if (pEvent.getStateChange() == 1) {
                ConnectionComponent.this.applicationServerChanged();
            }
        }
    }

    private class LocalConnectionProvider
    implements IConnectionProvider {
        private LocalConnectionProvider() {
        }

        public Connection getSelectedConnection() {
            return (Connection)ConnectionComponent.this.mServers.getSelectedItem();
        }
    }

    private class LocalComboBoxModel
    extends DefaultComboBoxModel {
        private LocalComboBoxModel() {
        }

        public void update(Connection pConnection) {
            int index = this.getIndexOf(pConnection);
            if (index != -1) {
                this.fireContentsChanged(this, index, index);
            }
        }
    }

    private class ConnectionPropertyChangeListener
    implements PropertyChangeListener {
        private ConnectionPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pEvent) {
            if ("Connection Created".equals(pEvent.getPropertyName())) {
                AppServer server = (AppServer)pEvent.getNewValue();
                ConnectionComponent.this.rebuildList(server);
            } else if ("Connection Modified".equals(pEvent.getPropertyName())) {
                AppServer server = (AppServer)pEvent.getNewValue();
                Connection c = (Connection)pEvent.getOldValue();
                ConnectionComponent.this.reloadConnection(c, server);
            }
        }
    }
}

