/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.studio.mds.resourcepalette;

import java.util.Enumeration;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.bpm.fusion.soa.mds.model.BPMConnectionDescriptor;
import oracle.bpm.fusion.studio.mds.resourcepalette.BPMConnectionProviderFactory;
import oracle.tip.tools.ide.common.resourcepalette.adapter.AbstractRCProvider;

public class BPMConnectionProvider
extends AbstractRCProvider
implements Referenceable {
    private BPMConnectionDescriptor bpmConnectionDescriptor;

    public BPMConnectionProvider() {
    }

    public BPMConnectionProvider(BPMConnectionDescriptor bpmConnectionDescriptor) {
        this.bpmConnectionDescriptor = bpmConnectionDescriptor;
    }

    public BPMConnectionDescriptor getBpmConnectionDescriptor() {
        if (this.bpmConnectionDescriptor == null) {
            this.createConnectionDescriptor();
        }
        return this.bpmConnectionDescriptor;
    }

    @Override
    public Reference getReference() {
        Reference reference = new Reference(this.getClass().getName(), this.getProviderFactory().getName(), null);
        Enumeration<Object> keys = this.getBpmConnectionDescriptor().keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            String value = this.bpmConnectionDescriptor.getProperty(name);
            if (name.equals("password")) {
                reference.add((RefAddr)new SecureRefAddr("password", value));
                continue;
            }
            reference.add(new StringRefAddr(name, value));
        }
        return reference;
    }

    public Class getProviderFactory() {
        return BPMConnectionProviderFactory.class;
    }

    private void createConnectionDescriptor() {
        this.bpmConnectionDescriptor = new BPMConnectionDescriptor();
        for (Object keyObj : this._properties.keySet()) {
            String key = (String)keyObj;
            String value = (String)this._properties.get(key);
            this.bpmConnectionDescriptor.setProperty(key, value);
        }
    }
}

