/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import javax.swing.Box;
import oracle.bpm.fusion.soa.wizard.BPAPanel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.javatools.ui.Colors;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.project.NewProjectPanel;
import oracle.jdevimpl.wizard.project.ProjectWizardUtils;

public class ProjectLocationPanel
extends DefaultTraversablePanel {
    BPAPanel bpaPanel = new BPAPanel(this);
    GridBagLayout gbLayout = new GridBagLayout();
    JMultiLineLabel lblTop = new JMultiLineLabel();
    NewProjectPanel pnlLocation = new NewProjectPanel();
    private URL _projURL;
    private WizardCallbacks callbacks;
    private static final long serialVersionUID = 7526472295622776147L;
    public static final String SELECTION = "selection";

    public ProjectLocationPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onEntry(TraversableContext dataContext) {
        boolean isBack = dataContext.getDirection() == 2;
        WizardCallbacks _callbacks = dataContext.getWizardCallbacks();
        if (!isBack) {
            _callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.FALSE, Boolean.FALSE);
        } else {
            _callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        }
        this.callbacks = _callbacks;
        URL projURL = (URL)dataContext.find("ProjectURL");
        this._init(projURL);
        _callbacks.wizardSetInitialFocus((Component)this.pnlLocation.getDefaultFocusComponent());
    }

    public void enableNext() {
        this.callbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        boolean isBack = dataContext.getDirection() == 2;
        this.pnlLocation.setInteractiveMode(!isBack);
        URL newURL = this.pnlLocation.getFileURL();
        if (newURL == null && !isBack) {
            throw new TraversalException(null);
        }
        if (ModelUtil.areDifferent((Object)this._projURL, (Object)newURL)) {
            if (newURL != null) {
                this._updateChildURL(newURL, dataContext, "OutputDirectory");
                this._updateChildURL(newURL, dataContext, "HtmlRootDir");
                this._updateURLPath(newURL, dataContext, "ProjectSourcePath");
            }
            dataContext.put("ProjectURL", (Object)newURL);
        }
        dataContext.put(SELECTION, (Object)this.bpaPanel.getSelection());
    }

    private void _updateChildURL(URL newProjURL, TraversableContext dataContext, String key) {
        URL newURL;
        URL childURL = (URL)dataContext.find(key);
        if (childURL != null && ModelUtil.areDifferent((Object)childURL, (Object)(newURL = ProjectWizardUtils.updateURL((URL)this._projURL, (URL)newProjURL, (URL)childURL)))) {
            dataContext.put(key, (Object)newURL);
        }
    }

    private void _updateURLPath(URL newProjURL, TraversableContext dataContext, String key) {
        URLPath newPath;
        URLPath path = (URLPath)dataContext.find(key);
        if (path != null && ModelUtil.areDifferent((Object)path, (Object)(newPath = ProjectWizardUtils.updateURLPath((URL)this._projURL, (URL)newProjURL, (URLPath)path)))) {
            dataContext.put(key, (Object)newPath);
        }
    }

    private void _init(URL projURL) {
        if (projURL != null) {
            this._projURL = projURL;
            URL dirURL = URLFileSystem.getParent((URL)projURL);
            String projFile = URLFileSystem.getFileName((URL)projURL);
            this.pnlLocation.setDirectoryURL(dirURL);
            this.pnlLocation.setFileName(projFile);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gbLayout);
        this.setDefaultTitle(WizardsArb.getString((int)7));
        this.lblTop.setText(JProjectArb.getString((int)156));
        this.lblTop.setForeground(Colors.HINT_TEXT);
        this.add((Component)this.lblTop, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(6, 0, 12, 0), 0, 0));
        this.add((Component)this.pnlLocation, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.bpaPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalBox(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
    }
}

