/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.wizard;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.repository.FusionProjectRepository;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.fusion.studio.wizard.AbstractNewProjectObjectWizard;
import oracle.bpm.resources.Msg;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.wizard.project.ProjectWizardLauncher;
import oracle.tip.tools.ide.bpel.v1.plugins.plugins.bpa.bpaserver.connections.BPAServer;
import oracle.tip.tools.ide.bpel.v1.plugins.plugins.bpa.bpaserver.connections.BPAServerManager;
import oracle.tip.tools.ide.bpel.v1.plugins.plugins.bpa.explorer.BpaExplorerSelectionData;
import oracle.tip.tools.ide.bpel.v1.plugins.plugins.bpa.util.BpaProjectBuilder;
import oracle.tip.tools.ide.bpel.v1.plugins.plugins.bpa.util.BpaServerDownloadUtil;
import oracle.tip.tools.ide.bpel.v1.plugins.plugins.bpa.util.ProjectBuilderData;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ide.IDE;
import oracle.tip.tools.ide.common.ide.IDEResolver;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;
import oracle.tip.tools.ide.fabric.addin.SCAProject;

public class NewBpmProjectFromBPAWizard
extends AbstractNewProjectObjectWizard {
    public NewBpmProjectFromBPAWizard() {
        this(DesignerMsg.NEW_PROJECT_FROM_BPA);
    }

    protected NewBpmProjectFromBPAWizard(Msg title) {
        super(title);
    }

    public boolean isAvailable(Context context) {
        return context != null && context.getWorkspace() != null;
    }

    public String getLongLabel() {
        return DesignerMsg.NEW_PROJECT_FROM_BPA_DESC.toString();
    }

    public boolean invoke(Context context) {
        final StringBuilder sb = new StringBuilder();
        context.setProject(null);
        final Workspace workspace = context.getWorkspace();
        final List servers = BPAServerManager.getInstance().getServers();
        for (BPAServer server : servers) {
            server.setBpm(true);
        }
        ProjectWizardLauncher launcher = new ProjectWizardLauncher(context, FusionSoaMsg.NEW_PROJECT_FROM_BPA_DESC.toString());
        launcher.setShowStepNumber(true);
        final StatusGlassPane glassPane = new StatusGlassPane((Component)Ide.getMainWindow().getContentPane());
        launcher.addPage("oracle.bpm.fusion.soa.wizard.ProjectLocationPanel", "f1_bpm_createprojbpalocationw_html");
        launcher.addFinishPage("f1_bpm_createprojbpasummaryw_html");
        Project project = launcher.runWizard();
        final BpaExplorerSelectionData selection = (BpaExplorerSelectionData)launcher.getNamespace().get("selection");
        if (project == null) {
            for (BPAServer server : servers) {
                server.setBpm(false);
            }
        }
        final Project p = project;
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Exception e;
                block19: {
                    e = null;
                    try {
                        if (p != null && selection != null) {
                            glassPane.setStatusDetailMessage(FusionSoaMsg.DOWNLOADING_FROM_BPA.getString());
                            selection.getServer().setBpm(true);
                            File zipFile = BpaServerDownloadUtil.downloadZip((BpaExplorerSelectionData)selection);
                            for (BPAServer server : servers) {
                                server.setBpm(false);
                            }
                            ProjectBuilderData data = new ProjectBuilderData();
                            data.m_zipFile = zipFile;
                            data.m_server = selection.getServer();
                            data.m_project = p;
                            data.m_model = selection.getModel();
                            data.m_bExportSubProcesses = selection.getExportSubProcesses();
                            glassPane.setStatusDetailMessage(FusionSoaMsg.EXTRACTING_PROCESS.getString());
                            BpaProjectBuilder.populateProjectFromZip((ProjectBuilderData)data);
                        }
                        if (p == null) break block19;
                        Ide.setActiveProject((Project)p);
                        glassPane.setStatusDetailMessage(FusionSoaMsg.INITIALIZING_PROJECT.getString());
                        NewBpmProjectFromBPAWizard.this.initProject(p);
                        try {
                            p.save();
                            workspace.add((Element)p, true);
                            workspace.save();
                            sb.append("true");
                        }
                        catch (IOException ioe) {
                            GraphUtils.displayError((Component)IDEResolver.getIDE().getFrame(), (Throwable)ioe);
                        }
                        if (selection == null) break block19;
                        URL projectDir = SCAProject.getSCAProject((Project)p).getProjectRoot();
                        URL processesDir = URLFactory.newDirURL((URL)projectDir, (String)"processes");
                        URL processBpmn = URLFactory.newURL((URL)processesDir, (String)(selection.getModel().name.replace(' ', '_') + ".bpmn"));
                        IDE ide = IDEResolver.getIDE();
                        try {
                            ide.openEditor(processBpmn);
                        }
                        catch (Throwable te) {
                            GraphUtils.displayError((Component)IDEResolver.getIDE().getFrame(), (Throwable)te);
                        }
                    }
                    catch (Exception ex) {
                        try {
                            e = ex;
                        }
                        catch (Throwable throwable) {
                            Runnable r2 = new Runnable(){

                                @Override
                                public void run() {
                                    glassPane.enableUserInput(true);
                                    if (p != null) {
                                        UpdateMessage.fireStructureChanged((Subject)p);
                                    }
                                }
                            };
                            if (SwingUtilities.isEventDispatchThread()) {
                                r2.run();
                            } else {
                                SwingUtilities.invokeLater(r2);
                            }
                            if (e != null) {
                                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
                            }
                            throw throwable;
                        }
                        Runnable r2 = new /* invalid duplicate definition of identical inner class */;
                        if (SwingUtilities.isEventDispatchThread()) {
                            r2.run();
                        } else {
                            SwingUtilities.invokeLater(r2);
                        }
                        if (e != null) {
                            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
                        }
                    }
                }
                Runnable r2 = new /* invalid duplicate definition of identical inner class */;
                if (SwingUtilities.isEventDispatchThread()) {
                    r2.run();
                } else {
                    SwingUtilities.invokeLater(r2);
                }
                if (e != null) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
                }
            }
        };
        glassPane.setStatusMessage(FusionStudioMsg.STATUS.getString(), FusionSoaMsg.CREATING_PROJECT.getString());
        glassPane.enableUserInput(false);
        Thread t = new Thread(r);
        t.start();
        return sb.length() != 0;
    }

    protected void initProject(Project project) {
        ((FusionProjectRepository)AbstractStudioWorkbench.getInstance().getRepository()).setTechnologyScope(project);
    }
}

