/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.util;

import java.awt.Component;
import javax.swing.table.AbstractTableModel;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.fusion.soa.util.AdapterExtensionUtil;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.Project;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;

public class BusinessCatalogValidations
extends Component {
    public static String validateAdapterName(@NotNull String adapterName) {
        if (adapterName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/util/BusinessCatalogValidations.validateAdapterName must not be null");
        }
        String errorMsg = " ";
        if (Str.isEmpty(adapterName)) {
            errorMsg = FusionSoaMsg.ADAPTER_NAME_NULL.toString();
        } else if (Character.isDigit(adapterName.charAt(0))) {
            errorMsg = FusionSoaMsg.ADAPTER_NAME_ALPHA.toString();
        } else if (!Identifier.isValid(adapterName)) {
            errorMsg = FusionSoaMsg.ADAPTER_NAME_ALPHA.toString();
        }
        return errorMsg;
    }

    public static String validateUniqueAdapter(@NotNull Project project, @NotNull String adapterName, @NotNull String moduleName) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/util/BusinessCatalogValidations.validateUniqueAdapter must not be null");
        }
        if (adapterName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/util/BusinessCatalogValidations.validateUniqueAdapter must not be null");
        }
        if (moduleName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/soa/util/BusinessCatalogValidations.validateUniqueAdapter must not be null");
        }
        String errorMsg = " ";
        MutableComponentCatalog componentCatalog = AdapterExtensionUtil.getComponentCatalog(project);
        ObjectTypeDescription root = componentCatalog.getRoot();
        try {
            ObjectTypeDescription parentModule = TypeUtils.createParentFromModule((ObjectTypeDescription)root, (String)moduleName, null);
            Boolean isNotDuplicate = !parentModule.hasInnerType(adapterName);
            if (!isNotDuplicate.booleanValue()) {
                errorMsg = FusionSoaMsg.ADAPTER_NAME_DUPLICATE.toString();
            }
        }
        catch (TypeCatalogException exc) {
            System.out.println("TypeCatalogException :\n" + exc.getMessage());
        }
        return errorMsg;
    }

    public static String validateModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/util/BusinessCatalogValidations.validateModuleName must not be null");
        }
        String errorMsg = " ";
        if (Str.isEmpty(moduleName)) {
            errorMsg = FusionSoaMsg.MODULE_NAME_NULL.toString();
        }
        return errorMsg;
    }

    public static String validateOperations(AbstractTableModel promotionTable) {
        String errorMsg = " ";
        Boolean operationSelected = false;
        for (int i = 0; i < promotionTable.getRowCount(); ++i) {
            if (promotionTable.getValueAt(i, 1) == null || !promotionTable.getValueAt(i, 0).equals(Boolean.TRUE)) continue;
            operationSelected = true;
        }
        if (!operationSelected.booleanValue()) {
            errorMsg = FusionSoaMsg.NO_OPERATION_PROMOTED.toString();
        }
        return errorMsg;
    }
}

