/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.rules;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.xml.namespace.QName;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.fusion.soa.rules.BusinessRuleUtils;
import oracle.bpm.fusion.soa.rules.DataDeclarationChooserDialog;
import oracle.bpm.fusion.soa.rules.ParametersEntry;
import oracle.bpm.geom.Point;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DropTargetHandler;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.util.Identifier;
import oracle.tip.tools.ide.bpel.v1.designer.resources.images.ImageCache;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.ButtonMenu;
import oracle.tip.tools.ide.rules.dictionarybuilder.WizardData;

class InputOutputParametersPanel
extends Panel {
    private DataDeclarationChooserDialog dataDeclarationDialog;
    private FlowNode flowNode;
    private BaseAction moveDownAction;
    private BaseAction moveUpAction;
    private BaseAction removeAction;
    private Table table;
    private static final Set<String> SIMPLE_TYPES = new HashSet<String>();

    InputOutputParametersPanel(UiContainer parent, FlowNode flowNode) {
        super(parent);
        this.flowNode = flowNode;
        this.init();
    }

    public void applyToWizardData(WizardData data) {
        Collection<ParametersEntry> entries = this.getEntries();
        BusinessRuleUtils.applyToWizardData(entries, data);
    }

    public boolean validateData() {
        WizardData tmpWizardData = new WizardData();
        this.applyToWizardData(tmpWizardData);
        if (tmpWizardData.getInputVarsXSD().size() < 1) {
            MessageDialog.showNotice((Msg)ProjectUiMsg.CREATE((Msg)ProjectModelMsg.BUSINESS_RULE), (Msg)FusionSoaMsg.MISSING_INPUT_DATA_OBJECTS);
            return false;
        }
        return true;
    }

    Sequence<Tuple<String, String>> createInputParameters() {
        return this.createParameters(true);
    }

    Sequence<Tuple<String, String>> createOutputParameters() {
        return this.createParameters(false);
    }

    private static void updateSelection(Table table, int[] selection) {
        int rowCount = table.getRowCount();
        if (selection.length > 0 && rowCount > 0) {
            int newSelection = selection[0];
            if (selection[0] >= rowCount) {
                newSelection = rowCount - 1;
            }
            table.setSelectionInterval(newSelection, newSelection);
        }
    }

    private Collection<ParametersEntry> getEntries() {
        return this.getModel().getData();
    }

    private FlowNode getFlowNode() {
        return this.flowNode;
    }

    private ParametersTableModel getModel() {
        return (ParametersTableModel)this.getTable().getModel();
    }

    private Table getTable() {
        return this.table;
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("fill, gapx 5, ins 0"));
        ToolBar toolBar = new ToolBar((UiContainer)this);
        final ParametersTableModel model = new ParametersTableModel();
        this.table = new Table((UiContainer)this, (TableModel)model);
        this.table.setPreferredRows(3);
        Transfer[] transfers = new Transfer[]{LocalObjectTransfer.getInstance(Sequence.class)};
        new DropTargetHandler((UiComponent)this, DndAction.COPY_OR_MOVE, transfers){

            public void drop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                Sequence dataDeclarations = (Sequence)data;
                for (DataDeclaration dataDeclaration : dataDeclarations) {
                    if (!this.isValid(dataDeclaration)) continue;
                    boolean isInput = InputOutputParametersPanel.this.dataDeclarationDialog.isInput();
                    boolean isUsed = this.isTypeUsed(dataDeclaration.getType(), isInput);
                    if (!isUsed) {
                        ParametersEntry entry = ParametersEntry.create(isInput, dataDeclaration.getName(), dataDeclaration);
                        InputOutputParametersPanel.this.getModel().addRow(entry);
                        continue;
                    }
                    JFrame jFrame = GraphUtils.getFrame((Component)InputOutputParametersPanel.this.asSwing());
                    GraphUtils.displayMessage((Component)jFrame, (String)FusionSoaMsg.RULE_DUPLICATED_TYPE_VAR_NOT_ALLOWED.getString(), (int)1);
                }
            }

            public boolean canDrop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                boolean result = false;
                if (data instanceof Sequence) {
                    Sequence dataDeclarations = (Sequence)data;
                    for (DataDeclaration dataDeclaration : dataDeclarations) {
                        if (!this.isValid(dataDeclaration)) continue;
                        result = true;
                        break;
                    }
                }
                return result;
            }

            private boolean isValid(DataDeclaration dataDeclaration) {
                SchemaObject schemaObject = BusinessRuleUtils.getSchemaObject(dataDeclaration);
                return schemaObject != null && (schemaObject.isElement() || this.isBasicTypeSupported(schemaObject));
            }

            private boolean isBasicTypeSupported(SchemaObject schemaObject) {
                QName qName;
                boolean result = false;
                if (schemaObject.isBasicType() && (qName = schemaObject.getQName()) != null) {
                    String localPart = qName.getLocalPart();
                    result = SIMPLE_TYPES.contains(localPart);
                }
                return result;
            }

            private boolean isTypeUsed(CatalogType type, boolean isInput) {
                return model.contains(type, isInput);
            }
        };
        this.table.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                InputOutputParametersPanel.this.selectionChanged(InputOutputParametersPanel.this.table.getSelectedRows());
            }
        });
        LabelProvider<Boolean> directionLabelProvider = new LabelProvider<Boolean>(){

            public Image getIcon(Boolean element) {
                return Image.create((Msg)this.getMsg(element));
            }

            public String getText(Boolean element) {
                return this.getMsg(element).getString();
            }

            private Msg getMsg(boolean element) {
                return element ? UIMsg.INPUT : UIMsg.OUTPUT;
            }
        };
        this.table.getColumn(0).setLabelProvider((LabelProvider)directionLabelProvider);
        ButtonMenu btnMenu = new ButtonMenu("", ImageCache.getIcon((String)"add16"));
        Action[] actions = new Action[]{new CreateInputAction(), new CreateOutputAction()};
        btnMenu.setActions(actions);
        this.removeAction = new BaseAction(UIMsg.REMOVE){

            public void run() {
                int[] selected = InputOutputParametersPanel.this.table.getSelectedRows();
                model.removeRows(selected);
                InputOutputParametersPanel.updateSelection(InputOutputParametersPanel.this.table, selected);
            }
        };
        this.moveUpAction = new BaseAction(UIMsg.MOVE_UP){

            public void run() {
                int row = InputOutputParametersPanel.this.table.getSelectedRow();
                model.moveRowUp(row);
                InputOutputParametersPanel.this.table.setSelectionInterval(row - 1, row - 1);
            }
        };
        this.moveUpAction.setEnabled(false);
        this.moveDownAction = new BaseAction(UIMsg.MOVE_DOWN){

            public void run() {
                int row = InputOutputParametersPanel.this.table.getSelectedRow();
                model.moveRowDown(row);
                InputOutputParametersPanel.this.table.setSelectionInterval(row + 1, row + 1);
            }
        };
        this.moveDownAction.setEnabled(false);
        toolBar.add(UiComponent.get((Object)btnMenu));
        toolBar.add(this.removeAction);
        toolBar.add(this.moveUpAction);
        toolBar.add(this.moveDownAction);
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)FusionSoaMsg.INPUT_OUTPUT_DATA_OBJECTS), "growx");
        this.add((UiComponent)toolBar, "wrap");
        this.add((UiComponent)this.table, "spanx 2, grow");
    }

    private void selectionChanged(int[] selectedRows) {
        boolean enable = selectedRows.length == 1;
        this.removeAction.setEnabled(selectedRows.length > 0);
        int row = this.getTable().getSelectedRow();
        this.moveUpAction.setEnabled(enable && row > 0);
        this.moveDownAction.setEnabled(enable && row < this.getModel().getRowCount() - 1);
    }

    private Sequence<Tuple<String, String>> createParameters(boolean input) {
        Collection<ParametersEntry> entries = this.getEntries();
        ArrayList<Tuple<String, String>> result = new ArrayList<Tuple<String, String>>(entries.size());
        for (ParametersEntry entry : entries) {
            if (input != entry.isInput()) continue;
            String parameterName = Identifier.argument(entry.getName());
            String source = input ? entry.getDataDeclaration().getName() : parameterName;
            String target = input ? parameterName : entry.getDataDeclaration().getName();
            result.add(Tuple.create(source, target));
        }
        return CollectionUtils.asSequence(result);
    }

    static {
        SIMPLE_TYPES.add("boolean");
        SIMPLE_TYPES.add("int");
        SIMPLE_TYPES.add("byte");
        SIMPLE_TYPES.add("long");
        SIMPLE_TYPES.add("short");
        SIMPLE_TYPES.add("double");
        SIMPLE_TYPES.add("integer");
        SIMPLE_TYPES.add("float");
        SIMPLE_TYPES.add("char");
        SIMPLE_TYPES.add("string");
        SIMPLE_TYPES.add("dateTime");
        SIMPLE_TYPES.add("bigInteger");
        SIMPLE_TYPES.add("bigDecimal");
    }

    private class CreateOutputAction
    extends ParameterAction {
        public CreateOutputAction() {
            super(FusionSoaMsg.ADD_OUTPUT_DATA_OBJECT.getString(), UIMsg.OUTPUT);
        }

        @Override
        protected boolean isInput() {
            return false;
        }
    }

    private class CreateInputAction
    extends ParameterAction {
        public CreateInputAction() {
            super(FusionSoaMsg.ADD_INPUT_DATA_OBJECT.getString(), UIMsg.INPUT);
        }

        @Override
        protected boolean isInput() {
            return true;
        }
    }

    private static class ParametersTableModel
    extends ProviderTableModel<ParametersEntry> {
        private static final MsgList TITLES = MsgList.create(UIMsg.DIRECTION, UIMsg.NAME, DesignerMsg.TYPE);
        private static final int COLUMN_DIRECTION = 0;
        private static final int COLUMN_NAME = 1;
        private static final int COLUMN_TYPE = 2;

        ParametersTableModel() {
            super(TITLES);
        }

        public Object getValueAt(int row, int column) {
            ParametersEntry entry = (ParametersEntry)this.getRow(row);
            switch (column) {
                case 0: {
                    return entry.isInput();
                }
                case 1: {
                    return entry.getName();
                }
                case 2: {
                    return entry.getDataDeclaration().getType().getDelegate().getText();
                }
            }
            return "";
        }

        public void setValueAt(Object value, int row, int column) {
            ParametersEntry entry = (ParametersEntry)this.getRow(row);
            if (column == 1) {
                entry.setName((String)value);
            }
        }

        public boolean contains(CatalogType type, boolean isInput) {
            List entries = this.getData();
            for (ParametersEntry entry : entries) {
                CatalogType catalogType;
                if (entry.isInput() != isInput || !type.equals(catalogType = entry.getDataDeclaration().getType())) continue;
                return true;
            }
            return false;
        }
    }

    private abstract class ParameterAction
    extends AbstractAction {
        public ParameterAction(String text, Msg msg) {
            super(text, Image.create((Msg)msg).asSwingIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (InputOutputParametersPanel.this.dataDeclarationDialog == null) {
                InputOutputParametersPanel.this.dataDeclarationDialog = new DataDeclarationChooserDialog(InputOutputParametersPanel.this.getOwnerWindow(), (DataDeclarationContainer)InputOutputParametersPanel.this.getFlowNode().getParentObject());
            }
            if (!InputOutputParametersPanel.this.dataDeclarationDialog.isVisible()) {
                InputOutputParametersPanel.this.dataDeclarationDialog.setVisible(true);
            }
            InputOutputParametersPanel.this.dataDeclarationDialog.setInput(this.isInput());
        }

        protected abstract boolean isInput();
    }
}

