/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.rules;

import oracle.bpm.adapter.Adaptable;
import oracle.bpm.designer.BusinessRuleData;
import oracle.bpm.designer.BusinessRuleService;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.fusion.soa.rules.BusinessRuleDialog;
import oracle.bpm.fusion.soa.rules.BusinessRulePanel;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.ide.model.Project;

public class BusinessRuleServiceImpl
implements BusinessRuleService {
    private static BusinessRuleServiceImpl instance = null;

    private BusinessRuleServiceImpl() {
    }

    public static BusinessRuleServiceImpl getInstance() {
        if (instance == null) {
            instance = new BusinessRuleServiceImpl();
        }
        return instance;
    }

    public BusinessRuleData createBusinessRule(UiWindow parent, FlowNode flowNode) {
        BusinessRuleData result = null;
        oracle.bpm.project.model.Project project = flowNode.getProject();
        if (project instanceof Adaptable) {
            Adaptable adaptable = (Adaptable)project;
            Project jdevProject = adaptable.as(Project.class);
            if (jdevProject != null) {
                BusinessRuleDialog dialog = BusinessRulePanel.createDialog(parent, flowNode);
                dialog.setVisible(true);
                if (dialog.userAccepted()) {
                    result = dialog.getBusinessRuleData();
                }
            } else {
                MessageDialog.showError((UiContainer)parent, (Msg)FusionSoaMsg.ERROR_NO_JDEV_PROJECT_BUSINESS_RULE(project.getId()));
            }
        }
        return result;
    }
}

