/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.rules;

import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.fusion.soa.rules.BusinessRuleAdvancedPanel;
import oracle.bpm.fusion.soa.rules.BusinessRuleDialog;
import oracle.bpm.fusion.soa.rules.BusinessRuleGeneralPanel;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.rules.dictionarybuilder.RuleType;
import oracle.tip.tools.ide.rules.dictionarybuilder.WizardData;
import oracle.tip.tools.ide.rules.dictionarybuilder.jdev.JDevDictionaryFileBuilder;

class BusinessRulePanel
extends Panel {
    private BusinessRuleAdvancedPanel advancedPanel;
    private BusinessRuleGeneralPanel generalPanel;
    private TabbedPane tabbedPane;

    BusinessRulePanel(UiContainer parent, FlowNode flowNode, Project jdevProject) {
        super(parent);
        this.init(flowNode, jdevProject);
    }

    public static BusinessRuleDialog createDialog(UiWindow parent, FlowNode flowNode) {
        return new BusinessRuleDialog(parent, flowNode);
    }

    public WizardData getWizardData() {
        WizardData data = new WizardData();
        this.generalPanel.applyToWizardData(data);
        this.advancedPanel.applyToWizardData(data);
        data.setType(RuleType.RULES);
        return data;
    }

    public String getHelpId() {
        return this.tabbedPane.getDefaultHelpId();
    }

    boolean validateData() {
        return this.generalPanel.validateData() && this.advancedPanel.validateData();
    }

    Sequence<Tuple<String, String>> createInputParameters() {
        return this.generalPanel.createInputParameters();
    }

    Sequence<Tuple<String, String>> createOutputParameters() {
        return this.generalPanel.createOutputParameters();
    }

    private void init(FlowNode flowNode, Project jdevProject) {
        this.setLayout((Layout)new BorderLayout());
        JDevDictionaryFileBuilder builder = new JDevDictionaryFileBuilder(jdevProject);
        this.tabbedPane = new TabbedPane((UiContainer)this);
        this.generalPanel = new BusinessRuleGeneralPanel((UiContainer)this.tabbedPane, flowNode, jdevProject, builder.getDefaultDictionaryName());
        this.advancedPanel = new BusinessRuleAdvancedPanel((UiContainer)this.tabbedPane, flowNode, builder.getDefaultPackage(), this.generalPanel.getNameTextField());
        this.tabbedPane.addTab(UIMsg.GENERAL, (UiComponent)this.generalPanel);
        this.tabbedPane.addTab(UIMsg.ADVANCED, (UiComponent)this.advancedPanel);
        this.add((UiComponent)this.tabbedPane, "Center");
    }
}

