/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.rules;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.soa.rules.InputOutputParametersPanel;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.bpel.shared.util.Helper;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.rules.dictionarybuilder.WizardData;
import oracle.tip.tools.ide.rules.editor.services.util.DecisionServiceUtil;
import oracle.tip.tools.ide.rules.editor.util.RulesSDKUtil;
import oracle.tip.tools.ide.rules.i18n.StringTranslator;

class BusinessRuleGeneralPanel
extends Panel {
    private InputOutputParametersPanel inputOutputParametersPanel;
    private Project jdevProject;
    private IdentifierTextField nameTextField;

    BusinessRuleGeneralPanel(UiContainer parent, FlowNode flowNode, Project jdevProject, String defaultName) {
        super(parent);
        this.jdevProject = jdevProject;
        this.init(flowNode, defaultName);
    }

    boolean validateData() {
        String dictName = this.getRuleName();
        boolean used = this.isNameAlreadyUsed(dictName + ".rules");
        if (used) {
            GraphUtils.displayMessage((Component)this.asSwing(), (String)StringTranslator.formatString((String)"RULE_CREATION_DIALOG_NAME_ALREADY_USED", (String)dictName), (int)0);
            this.nameTextField.requestFocus();
            return false;
        }
        if (!RulesSDKUtil.isValidName((String)dictName)) {
            GraphUtils.displayMessage((Component)this.asSwing(), (String)StringTranslator.getString((String)"RULE_CREATION_DIALOG_INVALID_NAME"), (int)0);
            this.nameTextField.requestFocus();
            return false;
        }
        return this.inputOutputParametersPanel.validateData();
    }

    String getRuleName() {
        return this.nameTextField.getText().trim();
    }

    void applyToWizardData(WizardData data) {
        data.setName(this.getRuleName());
        this.inputOutputParametersPanel.applyToWizardData(data);
    }

    IdentifierTextField getNameTextField() {
        return this.nameTextField;
    }

    Sequence<Tuple<String, String>> createInputParameters() {
        return this.inputOutputParametersPanel.createInputParameters();
    }

    Sequence<Tuple<String, String>> createOutputParameters() {
        return this.inputOutputParametersPanel.createOutputParameters();
    }

    private static List<File> getAllRulesFile(File dir) {
        ArrayList<File> list = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files.length > 0) {
            for (File file : files) {
                if (file.isFile() && file.getName().endsWith(".rules")) {
                    list.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                list.addAll(BusinessRuleGeneralPanel.getAllRulesFile(file));
            }
        }
        return list;
    }

    private void init(FlowNode flowNode, String defaultName) {
        this.setLayout((Layout)new MigLayout("fillx, gapx 5, ins 5"));
        this.nameTextField = new IdentifierTextField((UiContainer)this, defaultName, 30, true);
        this.inputOutputParametersPanel = new InputOutputParametersPanel((UiContainer)this, flowNode);
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.NAME));
        this.add((UiComponent)this.nameTextField, "growx, wrap");
        this.add((UiComponent)this.inputOutputParametersPanel, "spanx 2, grow");
    }

    private boolean isNameAlreadyUsed(String name) {
        Project project = this.getJdevProject();
        File dir = new File(Helper.getParent((URL)project.getURL()).getFile());
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        List<File> files = BusinessRuleGeneralPanel.getAllRulesFile(dir);
        for (File file : files) {
            if (!name.equalsIgnoreCase(file.getName())) continue;
            return true;
        }
        String ncName = name.substring(0, name.lastIndexOf("."));
        return DecisionServiceUtil.isRuleExisting((Project)project, (String)ncName);
    }

    private Project getJdevProject() {
        return this.jdevProject;
    }
}

