/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.rules;

import java.awt.Component;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.designer.BusinessRuleData;
import oracle.bpm.fusion.soa.rules.BusinessRulePanel;
import oracle.bpm.fusion.soa.rules.BusinessRuleUtils;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;
import oracle.tip.tools.ide.rules.dictionarybuilder.WizardData;
import oracle.tip.tools.ide.rules.i18n.StringTranslator;

class BusinessRuleDialog
extends OkCancelDialog {
    private BusinessRuleData businessRuleData;
    private BusinessRulePanel businessRulePanel;
    private FlowNode flowNode;

    public BusinessRuleDialog(UiWindow parent, FlowNode flowNode) {
        super(parent, ProjectUiMsg.CREATE((Msg)ProjectModelMsg.BUSINESS_RULE));
        this.flowNode = flowNode;
        this.init();
    }

    public String getHelpId() {
        return this.businessRulePanel.getHelpId();
    }

    public void ok() {
        if (this.businessRulePanel.validateData()) {
            final StatusGlassPane glass = new StatusGlassPane((Component)this.getContentPane().asSwing());
            glass.setVisibilityDelay(0);
            glass.enableUserInput(false);
            glass.setStatusMessage(StringTranslator.getString((String)"RE_PLEASE_WAIT"), StringTranslator.getString((String)"RE_CREATING_DICTIONARY"));
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        WizardData data = BusinessRuleDialog.this.businessRulePanel.getWizardData();
                        try {
                            BusinessRule businessRule = BusinessRuleUtils.createBusinessRule(BusinessRuleDialog.this.getProject(), data);
                            Sequence<Tuple<String, String>> inputParameters = BusinessRuleDialog.this.businessRulePanel.createInputParameters();
                            Sequence<Tuple<String, String>> outputParameters = BusinessRuleDialog.this.businessRulePanel.createOutputParameters();
                            BusinessRuleData businessRuleData = new BusinessRuleData(businessRule, inputParameters, outputParameters);
                            BusinessRuleDialog.this.setBusinessRuleData(businessRuleData);
                            BusinessRuleDialog.this.closeDialog(true);
                        }
                        catch (ProjectException e) {
                            MessageDialog.showError((Msg)e.getMsg(), (Throwable)e);
                            BusinessRuleDialog.this.closeDialog(false);
                        }
                    }
                    finally {
                        glass.enableUserInput(true);
                    }
                }
            };
            new Thread(r).start();
        }
    }

    BusinessRuleData getBusinessRuleData() {
        return this.businessRuleData;
    }

    private void setBusinessRuleData(BusinessRuleData businessRuleData) {
        this.businessRuleData = businessRuleData;
    }

    private oracle.bpm.project.model.Project getProject() {
        return this.flowNode.getProject();
    }

    private Project getJDevProject() {
        Project result = null;
        oracle.bpm.project.model.Project project = this.getProject();
        if (project instanceof Adaptable) {
            Adaptable adaptable = (Adaptable)project;
            result = adaptable.as(Project.class);
        }
        return result;
    }

    private void init() {
        UiContainer parent = this.getContentPane();
        this.businessRulePanel = new BusinessRulePanel(parent, this.flowNode, this.getJDevProject());
        parent.add((UiComponent)this.businessRulePanel, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private void closeDialog(final boolean isOk) {
        UiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BusinessRuleDialog.this.setUserAccepted(isOk);
                BusinessRuleDialog.this.close();
            }
        });
    }
}

