/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.rules;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationTree;
import oracle.bpm.designer.datadeclaration.tree.DataDeclarationTreeNode;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.ui.CloseableDialog;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DragSourceHandler;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDataDeclarationChooserDialog
extends CloseableDialog {
    protected AbstractDataDeclarationChooserDialog(@NotNull UiWindow parent, @NotNull DataDeclarationContainer dataDeclarationsContainer) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/rules/AbstractDataDeclarationChooserDialog.<init> must not be null");
        }
        if (dataDeclarationsContainer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/rules/AbstractDataDeclarationChooserDialog.<init> must not be null");
        }
        super(parent, ProjectUiMsg.BROWSE_DATA_OBJECTS, false);
        this.init(dataDeclarationsContainer);
    }

    public void ok() {
        this.close();
    }

    protected abstract UiContainer createHeader(@NotNull UiContainer var1);

    private void init(@NotNull DataDeclarationContainer dataDeclarationsContainer) {
        if (dataDeclarationsContainer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/rules/AbstractDataDeclarationChooserDialog.init must not be null");
        }
        UiContainer uiContainer = this.getContentPane();
        uiContainer.setLayout((Layout)new BorderLayout(5, 5));
        ScrollPane scrollPane = new ScrollPane(uiContainer);
        final DataDeclarationTree dataDeclarationsTree = new DataDeclarationTree((UiContainer)scrollPane, dataDeclarationsContainer);
        new DragSourceHandler((UiComponent)dataDeclarationsTree, DndAction.COPY_OR_MOVE){

            public Transfer[] getTransfers() {
                DataDeclarationTreeNode dataDeclarationTreeNode;
                Transfer[] result = Transfer.NONE;
                TreeNode node = dataDeclarationsTree.getSelectedTreeNode();
                if (node instanceof DataDeclarationTreeNode && !(dataDeclarationTreeNode = (DataDeclarationTreeNode)node).isShadowed() && dataDeclarationTreeNode.isFirstLevelDeclarationNode()) {
                    result = new Transfer[]{LocalObjectTransfer.getInstance(Sequence.class)};
                }
                return result;
            }

            public Object getObject(Transfer transfer) {
                TreeNode node;
                Sequence result = null;
                if (LocalObjectTransfer.getInstance(Sequence.class) == transfer && (node = dataDeclarationsTree.getSelectedTreeNode()) instanceof DataDeclarationTreeNode) {
                    DataDeclarationTreeNode dataDeclarationTreeNode = (DataDeclarationTreeNode)node;
                    result = dataDeclarationTreeNode.getDeclarationsPath();
                }
                return result;
            }
        };
        UiContainer headerPanel = this.createHeader(uiContainer);
        uiContainer.add((UiComponent)headerPanel, (Object)"North");
        scrollPane.add((UiComponent)dataDeclarationsTree);
        scrollPane.setView((UiComponent)dataDeclarationsTree);
        uiContainer.add((UiComponent)scrollPane, (Object)"Center");
        UiContainer parent = this.getParent();
        Point location = parent.getLocation();
        this.setLocation(location.getX() + parent.getWidth(), location.getY());
        this.setSize(300, 400);
        this.revalidate();
    }
}

