/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.wizard;

import javax.naming.NamingException;
import javax.swing.Icon;
import oracle.adf.share.jndi.AdfJndiContext;
import oracle.bpm.fusion.soa.mds.action.EditBpmRepositoryConnectionAction;
import oracle.bpm.fusion.soa.mds.action.NewBpmRepositoryConnectionAction;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.mds.resourcepalette.BPMConnectionProvider;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.ide.Context;
import oracle.ide.wizard.Wizard;
import oracle.jdeveloper.rescat2.RescatContextRegistry;
import oracle.jdeveloper.rescat2.nodes.RescatContext;

public class BPMConnectionWizard
extends Wizard {
    public boolean isAvailable(Context context) {
        return true;
    }

    public boolean invoke(Context ideContext) {
        if (this.isCreateMode(ideContext)) {
            return this.invokeCreate(ideContext);
        }
        return this.invokeEdit(ideContext);
    }

    public String getShortLabel() {
        return FusionStudioMsg.BPM_REPOSITORY_CONNECTION.getString();
    }

    public Icon getIcon() {
        return Image.create((Msg)FusionStudioMsg.BPM_REPOSITORY_CONNECTION).asSwingIcon();
    }

    private boolean isCreateMode(Context ideContext) {
        String targetConnId = (String)ideContext.getProperty("oracle.jdeveloper.rescat2.connectionId");
        return targetConnId == null || targetConnId.length() <= 0;
    }

    private boolean invokeCreate(Context ideContext) {
        new NewBpmRepositoryConnectionAction().run();
        return true;
    }

    private boolean invokeEdit(Context ideContext) {
        String targetConnId = (String)ideContext.getProperty("oracle.jdeveloper.rescat2.connectionId");
        RescatContextRegistry registry = RescatContextRegistry.getInstance();
        RescatContext resCatContext = registry.getResourcePaletteContext();
        AdfJndiContext connectionContext = resCatContext.getConnectionContext();
        try {
            BPMConnectionProvider oldConnectionProvider = (BPMConnectionProvider)connectionContext.lookup(targetConnId);
            new EditBpmRepositoryConnectionAction(oldConnectionProvider.getBpmConnectionDescriptor()).run();
            return true;
        }
        catch (NamingException e) {
            MdsLogger.getInstance().logStackTrace(e);
            MessageDialog.showError((Throwable)e);
            return false;
        }
    }
}

