/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.ui;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bpm.fusion.soa.mds.model.BPMConnectionDescriptor;
import oracle.bpm.fusion.soa.mds.ui.BpmConnectionPanel;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.ide.Ide;
import org.jetbrains.annotations.Nullable;

public class NewRepositoryConnectionDialog
extends JEWTDialog {
    private BPMConnectionDescriptor bpmConnectionDescriptor;
    private BpmConnectionPanel connectionPanel;
    private boolean editing;
    private static final long serialVersionUID = -3908282116458626985L;

    public NewRepositoryConnectionDialog(Msg title) {
        this(null, title);
    }

    public NewRepositoryConnectionDialog(@Nullable BPMConnectionDescriptor bpmConnectionDescriptor, Msg title) {
        super((Frame)Ide.getMainWindow());
        this.bpmConnectionDescriptor = bpmConnectionDescriptor;
        this.editing = bpmConnectionDescriptor != null;
        this.setTitle(title.getString());
        this.buildUi();
        HelpUtils.setHelpID((JComponent)((JComponent)this.getContent()), (String)"f1_bpm_mdsnewconnection_html");
    }

    public BPMConnectionDescriptor getConnection() {
        return this.bpmConnectionDescriptor;
    }

    protected void dismissDialog(boolean cancelled) {
        if (!cancelled) {
            try {
                this.connectionPanel.validateValues();
                if (!this.editing) {
                    this.bpmConnectionDescriptor = new BPMConnectionDescriptor();
                }
                this.connectionPanel.fillValues(this.bpmConnectionDescriptor);
            }
            catch (InputValidationException e) {
                MdsLogger.getInstance().logStackTrace(e);
                MessageDialog.showError((Msg)e.getKey());
                return;
            }
        }
        super.dismissDialog(cancelled);
    }

    private void buildUi() {
        DialogHeader header = new DialogHeader(FusionStudioMsg.BPM_REPOSITORY_CONNECTION_HINT.getString(), Image.create((Msg)FusionStudioMsg.BPM_REPOSITORY_CONNECTION_HINT).asAwtImage());
        Panel contentPanel = new Panel(null);
        contentPanel.setLayout((Layout)new MigLayout("fillx"));
        this.connectionPanel = new BpmConnectionPanel((UiContainer)contentPanel, this.bpmConnectionDescriptor);
        Panel createConnectionInPanel = this.buildCreateConnectionInPanel();
        contentPanel.add((UiComponent)createConnectionInPanel, (Object)"growx, wrap");
        contentPanel.add((UiComponent)this.connectionPanel, (Object)"growx");
        this.setDialogHeader((Component)header);
        this.setContent(contentPanel.asSwing());
        this.setResizable(true);
        this.setModal(true);
        this.setButtonMask(7);
    }

    private Panel buildCreateConnectionInPanel() {
        Panel createConnectionInPanel = new Panel(null);
        createConnectionInPanel.setLayout((Layout)new MigLayout("fillx"));
        RadioButton applicationRadioButton = new RadioButton((UiContainer)createConnectionInPanel, FusionStudioMsg.APPLICATION_RESOURCES.getString());
        applicationRadioButton.setEnabled(false);
        RadioButton ideRadioButton = new RadioButton((UiContainer)createConnectionInPanel, FusionStudioMsg.IDE_CONNECTIONS.getString());
        ideRadioButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)applicationRadioButton);
        group.add((AbstractButton)ideRadioButton);
        createConnectionInPanel.add((UiComponent)Label.create((UiContainer)createConnectionInPanel, (Msg)FusionStudioMsg.CREATE_CONNECTION_IN));
        createConnectionInPanel.add((UiComponent)applicationRadioButton);
        createConnectionInPanel.add((UiComponent)ideRadioButton);
        return createConnectionInPanel;
    }
}

