/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.ui;

import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.designer.validator.ValidationException;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.command.CreateSnapshotCommand;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.SnapshotProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.Nullable;

public class NewProjectSnapshotDialog
extends OkCancelDialog {
    private TextArea commentTextArea;
    private List<LocalRef<SnapshotProject>> currentSnapshots;
    private PublicShareProject mdProject;
    private TextField nameTextField;
    private LocalRef<SnapshotProject> snapshot;
    private String suggestedName;

    public NewProjectSnapshotDialog(UiWindow parent, PublicShareProject mdProject, String nextName, List<LocalRef<SnapshotProject>> currentSnapshots) {
        super(parent, FusionStudioMsg.NEW_PROJECT_SNAPSHOT((String)mdProject.getName()));
        this.mdProject = mdProject;
        this.currentSnapshots = currentSnapshots;
        this.suggestedName = nextName;
        this.buildUi();
    }

    public void ok() {
        try {
            this.validateValues();
            this.setCursor(Cursor.get((Cursor.CursorType)Cursor.CursorType.WAIT_CURSOR));
            new CreateSnapshotCommand(this.mdProject, this.nameTextField.getText(), this.commentTextArea.getText()).execute();
            this.snapshot = StudioMetadataService.getInstance().getService().getSnapshot(this.mdProject.getId(), this.nameTextField.getText());
            this.setVisible(false);
        }
        catch (ValidationException e) {
            MdsLogger.getInstance().logStackTrace(e);
            MessageDialog.showError((Msg)e.getMsg());
        }
        catch (ExecutionException e) {
            MdsLogger.getInstance().logStackTrace(e);
            MessageDialog.showError((Msg)UIMsg.TO_MSG((String)e.getMessage()));
            this.setVisible(false);
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logStackTrace(e);
            MessageDialog.showError((Throwable)e);
            this.setVisible(false);
        }
    }

    public LocalRef<SnapshotProject> getSnapshot() throws MetadataException {
        return this.snapshot;
    }

    private void validateValues() throws ValidationException, MetadataException {
        final String snapshotName = this.nameTextField.getText();
        if (!Identifier.isValid(snapshotName)) {
            String validName = Identifier.valid(snapshotName);
            String anotherName = Str.isEmpty(validName) ? this.suggestedName : validName;
            throw new ValidationException(FusionStudioMsg.INVALID_SNAPSHOT_NAME((String)snapshotName, (String)anotherName));
        }
        boolean existsSnapshot = CollectionUtils.exists(this.currentSnapshots, new Predicate<LocalRef<SnapshotProject>>(){

            @Override
            public boolean check(@Nullable LocalRef<SnapshotProject> value) {
                return value.getName().equals(snapshotName);
            }
        });
        if (existsSnapshot) {
            throw new ValidationException(FusionStudioMsg.SNAPSHOT_ALREADY_EXISTS((String)snapshotName));
        }
    }

    private void buildUi() {
        this.buildMainPanel();
        this.setLocationRelativeTo((UiComponent)this.getParent());
        this.pack();
    }

    private void buildMainPanel() {
        this.getContentPane().setLayout((Layout)new BorderLayout());
        Panel panel = new Panel(this.getContentPane());
        panel.setLayout((Layout)new MigLayout("fill"));
        this.nameTextField = new TextField((UiContainer)panel);
        this.nameTextField.setText(this.suggestedName);
        this.commentTextArea = new TextArea((UiContainer)panel);
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)FusionStudioMsg.NAME));
        panel.add((UiComponent)this.nameTextField, (Object)"grow, width 300, wrap");
        panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)FusionStudioMsg.DESCRIPTION));
        panel.add((UiComponent)this.commentTextArea, (Object)"grow, width 300");
        this.getContentPane().add((UiComponent)panel, (Object)"Center");
    }
}

