/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.model.BPMConnectionDescriptor;
import oracle.bpm.fusion.soa.mds.model.BPMConnectionsHelper;
import oracle.bpm.fusion.soa.mds.model.BPMConnectionsManager;
import oracle.bpm.fusion.soa.mds.model.BpmConnectionException;
import oracle.bpm.fusion.soa.mds.ui.IndProgressMonitorRunnableDecorator;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.VisibilityListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.PasswordField;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextField;
import oracle.ide.Context;
import oracle.jdeveloper.server.connection.AppServerManager;
import oracle.rc.asadapter.connection.AsAdapterEvent;
import oracle.rc.asadapter.connection.StoreListener;
import oracle.tip.tools.ide.common.resourcepalette.adapter.ConnectionsHelper;
import oracle.tip.tools.ide.common.resourcepalette.adapter.mds.MDSConnectionDescriptor;
import oracle.tip.tools.ide.common.resourcepalette.adapter.mds.MDSProvider;
import oracle.tip.tools.ide.common.resourcepalette.adapter.mds.wizard.MDSConnectionWizard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmConnectionPanel
extends Panel {
    private Button addRepositoryButton;
    private Button addSoaInfraButton;
    @Nullable
    private BPMConnectionDescriptor bpmConnectionDescriptor;
    private TextField connectionNameField;
    private TextArea connStatusTextArea;
    private CheckBox overrideUserPassChck;
    private PasswordField passwordField;
    private ComboBox<String> repositoryCombo;
    private ComboBox<String> soaInfraCombo;
    private StoreListener storeListener;
    private TextField usernameField;
    private static final String EDIT_SOA_INFRA_SERVER_URL_PANEL = "editSoaInfraServerPanel";
    private static final String SELECT_SOA_INFRA_SERVER_PANEL = "selectSoaInfraServerPanel";

    public BpmConnectionPanel(@NotNull UiContainer parent, @Nullable BPMConnectionDescriptor bpmConnectionDescriptor) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/ui/BpmConnectionPanel.<init> must not be null");
        }
        super(parent);
        this.bpmConnectionDescriptor = bpmConnectionDescriptor;
        this.setLayout((Layout)new BorderLayout());
        this.init();
        this.startListeningAppServerManager();
        this.addVisibilityListener(new VisibilityListener(){

            public void onDispose() {
                BpmConnectionPanel.this.stopListeningAppServerManager();
            }
        });
    }

    public void fillValues(BPMConnectionDescriptor bpmConnectionDescriptor) {
        if (this.connectionNameField != null) {
            bpmConnectionDescriptor.setName(this.connectionNameField.getText());
        }
        bpmConnectionDescriptor.setUser(this.usernameField.getText());
        bpmConnectionDescriptor.setPassword(this.passwordField.getText());
        bpmConnectionDescriptor.setSoaInfraServer((String)this.soaInfraCombo.getSelectedItem());
        bpmConnectionDescriptor.setBPMRepositoryServer((String)this.repositoryCombo.getSelectedItem());
        bpmConnectionDescriptor.setUseAppServerUsrPass(!this.overrideUserPassChck.isSelected());
    }

    public void validateValues() throws InputValidationException {
        if (!this.isEditMode()) {
            InputValidationException.assertNotEmpty(this.connectionNameField.getText(), DesignerMsg.OBJECT_FIELD_CANNOT_BE_EMPTY((Msg)FusionStudioMsg.CONNECTION_NAME));
            Msg existsConnectionMsg = DesignerMsg.OBJECT_ALREADY_EXISTS((Msg)DesignerMsg.CONNECTION_NAME, (String)this.connectionNameField.getText());
            InputValidationException.assertFalse(BPMConnectionsHelper.existsConnectionByName(this.connectionNameField.getText()), existsConnectionMsg);
        }
        if (this.overrideUserPassChck.isSelected()) {
            InputValidationException.assertNotEmpty(this.usernameField.getText(), DesignerMsg.OBJECT_FIELD_CANNOT_BE_EMPTY((Msg)FusionStudioMsg.USER_NAME));
            InputValidationException.assertNotEmpty(this.passwordField.getText(), DesignerMsg.OBJECT_FIELD_CANNOT_BE_EMPTY((Msg)FusionStudioMsg.PASSWORD));
        }
        InputValidationException.assertNotNull(this.soaInfraCombo.getSelectedItem(), DesignerMsg.OBJECT_FIELD_CANNOT_BE_EMPTY((Msg)FusionStudioMsg.APPLICATION_SERVER));
        InputValidationException.assertNotNull(this.repositoryCombo.getSelectedItem(), DesignerMsg.OBJECT_FIELD_CANNOT_BE_EMPTY((Msg)FusionStudioMsg.REPOSITORY_SERVER));
    }

    private void startListeningAppServerManager() {
        this.storeListener = new StoreListener(){

            public void storeEvent(AsAdapterEvent asAdapterEvent) {
                if (StoreListener.OBJECT_ADDED.equals(asAdapterEvent.getType()) && BpmConnectionPanel.this.getSoaInfraServers().contains(asAdapterEvent.getData())) {
                    String data = (String)asAdapterEvent.getData();
                    BpmConnectionPanel.this.soaInfraCombo.addItem((Object)data);
                    BpmConnectionPanel.this.soaInfraCombo.setSelectedItem((Object)data);
                }
            }
        };
        AppServerManager.getInstance().addStoreListener(this.storeListener);
    }

    private void stopListeningAppServerManager() {
        AppServerManager.getInstance().removeStoreListener(this.storeListener);
    }

    private void init() {
        Panel mainPanel = new Panel((UiContainer)this);
        mainPanel.setLayout((Layout)new MigLayout("fill"));
        Panel connectionPanel = new Panel((UiContainer)mainPanel, FusionStudioMsg.CONNECTION);
        connectionPanel.setLayout((Layout)new MigLayout("fill, gapx 5, ins 5, width 500"));
        Panel connectionNameLabel = null;
        if (this.isEditMode()) {
            connectionNameLabel = UiFactory.createDisabledField((UiContainer)connectionPanel, (String)this.bpmConnectionDescriptor.getName(), null);
        } else {
            this.connectionNameField = new TextField((UiContainer)connectionPanel);
        }
        this.usernameField = new TextField((UiContainer)connectionPanel);
        this.passwordField = new PasswordField((UiContainer)connectionPanel);
        this.soaInfraCombo = UiFactory.createComboBox((UiContainer)connectionPanel, this.getSoaInfraServers());
        this.addSoaInfraButton = Button.createIconic((UiContainer)connectionPanel, (Msg)UIMsg.ADD);
        this.addSoaInfraButton.addActionListener(this.getAddSoaInfraAction());
        this.overrideUserPassChck = CheckBox.create((UiContainer)connectionPanel);
        this.overrideUserPassChck.addActionListener(this.getOverrideUsrPassActionListener());
        Button testConnectionButton = new Button((UiContainer)mainPanel, FusionStudioMsg.TEST_CONNECTION);
        testConnectionButton.addActionListener(this.getTestConnectionButtonListener());
        this.connStatusTextArea = new TextArea((UiContainer)mainPanel, ScrollPolicy.AS_NEEDED, ScrollPolicy.NEVER);
        this.connStatusTextArea.setLineWrap(true);
        this.repositoryCombo = UiFactory.createComboBox((UiContainer)connectionPanel, this.getRepositoryServers());
        this.addRepositoryButton = Button.createIconic((UiContainer)connectionPanel, (Msg)UIMsg.ADD);
        this.addRepositoryButton.addActionListener(this.getAddRepositoryAction());
        connectionPanel.add((UiComponent)Label.create((UiContainer)connectionPanel, (Msg)FusionStudioMsg.CONNECTION_NAME));
        if (this.isEditMode()) {
            connectionPanel.add((UiComponent)connectionNameLabel, (Object)"grow, wrap");
        } else {
            connectionPanel.add((UiComponent)this.connectionNameField, (Object)"grow, wrap");
        }
        connectionPanel.add((UiComponent)Label.create((UiContainer)connectionPanel, (Msg)FusionStudioMsg.APPLICATION_SERVER));
        connectionPanel.add(this.soaInfraCombo, (Object)"grow");
        connectionPanel.add((UiComponent)this.addSoaInfraButton, (Object)"wrap");
        connectionPanel.add((UiComponent)this.overrideUserPassChck);
        connectionPanel.add((UiComponent)Label.create((UiContainer)connectionPanel, (Msg)FusionStudioMsg.OVERRIDE_USR_PASS), (Object)"grow, wrap");
        connectionPanel.add((UiComponent)Label.create((UiContainer)connectionPanel, (Msg)FusionStudioMsg.USER_NAME));
        connectionPanel.add((UiComponent)this.usernameField, (Object)"grow, wrap");
        connectionPanel.add((UiComponent)Label.create((UiContainer)connectionPanel, (Msg)FusionStudioMsg.PASSWORD));
        connectionPanel.add((UiComponent)this.passwordField, (Object)"grow, wrap");
        connectionPanel.add((UiComponent)Label.create((UiContainer)connectionPanel, (Msg)FusionStudioMsg.REPOSITORY_SERVER));
        connectionPanel.add(this.repositoryCombo, (Object)"grow");
        connectionPanel.add((UiComponent)this.addRepositoryButton, (Object)"wrap");
        mainPanel.add((UiComponent)connectionPanel, (Object)"grow, wrap");
        mainPanel.add((UiComponent)testConnectionButton, (Object)"wrap");
        mainPanel.add((UiComponent)Label.createWithNoColon((UiContainer)mainPanel, (Msg)FusionStudioMsg.STATUS), (Object)"wrap");
        this.connStatusTextArea.setEditable(false);
        mainPanel.add((UiComponent)this.connStatusTextArea, (Object)"grow, height 100, span 2");
        this.add((UiComponent)mainPanel, "Center");
        this.populateValues();
    }

    private ActionListener getOverrideUsrPassActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BpmConnectionPanel.this.usernameField.setEnabled(BpmConnectionPanel.this.overrideUserPassChck.isSelected());
                BpmConnectionPanel.this.passwordField.setEnabled(BpmConnectionPanel.this.overrideUserPassChck.isSelected());
            }
        };
    }

    private ActionListener getTestConnectionButtonListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BpmConnectionPanel.this.validateValues();
                    IndProgressMonitorRunnableDecorator progressMonitorDecorator = new IndProgressMonitorRunnableDecorator(BpmConnectionPanel.this.asSwing(), FusionStudioMsg.CONNECTING, new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            BpmConnectionPanel.this.connStatusTextArea.setText(FusionStudioMsg.WORKING.toString());
                            BPMConnectionDescriptor connectionDescriptor = new BPMConnectionDescriptor();
                            BpmConnectionPanel.this.fillValues(connectionDescriptor);
                            try {
                                StudioMetadataService.getInstance().testConnection(connectionDescriptor);
                                BpmConnectionPanel.this.connStatusTextArea.setText(FusionStudioMsg.SUCCESS.toString());
                            }
                            catch (BpmConnectionException e1) {
                                MdsLogger.getInstance().logStackTrace(e1);
                                BpmConnectionPanel.this.connStatusTextArea.setText(FusionStudioMsg.TEST_FAILED.toString() + e1.getKey().toString());
                            }
                            finally {
                                if (FusionStudioMsg.WORKING.toString().equals(BpmConnectionPanel.this.connStatusTextArea.getText())) {
                                    BpmConnectionPanel.this.connStatusTextArea.setText(FusionStudioMsg.TEST_FAILED.toString());
                                }
                            }
                        }
                    });
                    progressMonitorDecorator.run();
                }
                catch (InputValidationException e1) {
                    MessageDialog.showError((Msg)e1.getKey());
                }
            }
        };
    }

    private boolean isEditMode() {
        return this.bpmConnectionDescriptor != null;
    }

    private void populateValues() {
        if (this.isEditMode()) {
            if (this.bpmConnectionDescriptor.getSoaInfraServer() == null && !this.getSoaInfraServers().isEmpty()) {
                this.soaInfraCombo.setSelectedIndex(0);
            } else {
                this.soaInfraCombo.setSelectedItem((Object)this.bpmConnectionDescriptor.getSoaInfraServer());
            }
            this.overrideUserPassChck.setSelected(!this.bpmConnectionDescriptor.isUseAppServerUsrPass());
            this.usernameField.setText(this.bpmConnectionDescriptor.getUser());
            this.passwordField.setText(this.bpmConnectionDescriptor.getPassword());
            if (this.bpmConnectionDescriptor.getBPMRepositoryServer() == null && !this.getRepositoryServers().isEmpty()) {
                this.repositoryCombo.setSelectedIndex(0);
            } else {
                this.repositoryCombo.setSelectedItem((Object)this.bpmConnectionDescriptor.getBPMRepositoryServer());
            }
        } else {
            try {
                BPMConnectionsManager.getInstance();
                this.connectionNameField.setText(BPMConnectionsManager.nextNameForRepositoryConnection());
            }
            catch (Exception e) {
                MdsLogger.getInstance().logStackTrace(e);
            }
        }
        this.usernameField.setEnabled(this.overrideUserPassChck.isSelected());
        this.passwordField.setEnabled(this.overrideUserPassChck.isSelected());
    }

    private ActionListener getAddRepositoryAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MDSConnectionWizard mdsConnectionWizard = new MDSConnectionWizard();
                mdsConnectionWizard.invoke(Context.newIdeContext());
                BpmConnectionPanel.this.updateRepositoriesList();
            }
        };
    }

    private void updateRepositoriesList() {
        this.repositoryCombo.removeAllItems();
        for (String connection : this.getRepositoriesConnections()) {
            if (this.repositoryCombo.containsItem((Object)connection)) continue;
            this.repositoryCombo.addItem((Object)connection);
            this.repositoryCombo.setSelectedItem((Object)connection);
        }
        this.usernameField.setEnabled(this.overrideUserPassChck.isSelected());
        this.passwordField.setEnabled(this.overrideUserPassChck.isSelected());
    }

    private List<String> getRepositoriesConnections() {
        ArrayList<String> connections = new ArrayList<String>();
        try {
            List stringList = ConnectionsHelper.getResourcePaletteConnections(MDSProvider.class);
            for (String connectionName : stringList) {
                MDSProvider provider = (MDSProvider)ConnectionsHelper.getResourcePaletteProvider((String)connectionName);
                MDSConnectionDescriptor connectionDesc = provider.getConnectionDescriptor();
                if (!"obpm".equals(connectionDesc.getMDS_PARTITION_NAME())) continue;
                connections.add(connectionName);
            }
        }
        catch (Exception e) {
            MdsLogger.getInstance().logStackTrace(e);
            MessageDialog.showError((Throwable)e);
        }
        return connections;
    }

    private ActionListener getAddSoaInfraAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AppServerManager.getInstance().runNewAppServerWizardDialog();
            }
        };
    }

    private void updateSoaInfraConnectionsList() {
        this.soaInfraCombo.removeAllItems();
        for (String soaInfraServer : this.getSoaInfraServers()) {
            this.soaInfraCombo.addItem((Object)soaInfraServer);
            this.soaInfraCombo.setSelectedItem((Object)soaInfraServer);
        }
    }

    private Collection<String> getRepositoryServers() {
        return this.getRepositoriesConnections();
    }

    private Collection<String> getSoaInfraServers() {
        return AppServerManager.getInstance().list();
    }
}

