/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.command;

import oracle.bpm.command.Command;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.exception.MetadataException;

public class UnlockMdsProjectCommand
implements Command {
    private PublicShareProject publicShareProject;

    public UnlockMdsProjectCommand(PublicShareProject publicShareProject) {
        this.publicShareProject = publicShareProject;
    }

    @Override
    public String getName() {
        return "Unlock Mds project: " + this.publicShareProject.getName();
    }

    @Override
    public Object getAffectedObject() {
        return this.publicShareProject;
    }

    @Override
    public void undo() {
    }

    @Override
    public Object execute() throws ExecutionException {
        try {
            oracle.bpm.pml.service.StudioMetadataService studioMetadataService = StudioMetadataService.getInstance().getService();
            studioMetadataService.releaseLock(this.publicShareProject);
            this.publicShareProject = (PublicShareProject)studioMetadataService.loadProject(PublicShareProject.class, this.publicShareProject.getId()).get();
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logMessage(e.getStackTraceString());
            throw new ExecutionException(e);
        }
        return this.publicShareProject;
    }
}

