/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.command;

import oracle.bpm.command.Command;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.exception.MetadataException;

public class LockMdsProjectCommand
implements Command {
    private PublicShareProject publicShareProject;

    public LockMdsProjectCommand(PublicShareProject publicShareProject) {
        this.publicShareProject = publicShareProject;
    }

    @Override
    public String getName() {
        return "Lock Mds project: " + this.publicShareProject.getName();
    }

    @Override
    public Object getAffectedObject() {
        return this.publicShareProject;
    }

    @Override
    public void undo() {
    }

    @Override
    public Object execute() throws ExecutionException {
        try {
            oracle.bpm.pml.service.StudioMetadataService metadataService = StudioMetadataService.getInstance().getService();
            metadataService.getLock(this.publicShareProject);
            this.publicShareProject = (PublicShareProject)metadataService.loadProject(PublicShareProject.class, this.publicShareProject.getId()).get();
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logMessage(e.getStackTraceString());
            throw new ExecutionException(e);
        }
        return this.publicShareProject;
    }
}

