/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.command;

import oracle.bpm.command.Command;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.MdsProjectNode;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.exception.MetadataException;

public class DeleteMdsProjectCommand
implements Command {
    private MdProject mdProject;

    public DeleteMdsProjectCommand(MdProject mdProject) {
        this.mdProject = mdProject;
    }

    @Override
    public String getName() {
        return "Delete MDS Project: " + this.getAffectedObject().getName();
    }

    public MdProject getAffectedObject() {
        return this.mdProject;
    }

    @Override
    public Object execute() throws ExecutionException {
        String id = this.mdProject.getId();
        try {
            if (this.mdProject.isTemplate()) {
                StudioMetadataService.getInstance().getService().deleteTemplateProject(id, true);
            } else {
                StudioMetadataService.getInstance().getService().deletePublicShare(id);
            }
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logMessage(e.getStackTraceString());
            throw new ExecutionException(e);
        }
        return this.mdProject;
    }

    @Override
    public void undo() {
    }

    private ProjectFolder getProjectFolder(MdsProjectNode mdsProjectNode) {
        return (ProjectFolder)((MdProject)mdsProjectNode.as(MdProject.class)).getFolder().get();
    }
}

