/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.command;

import java.io.File;
import java.net.URI;
import oracle.bpm.command.Command;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.project.io.fs.AbstractProjectRepository;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.OpenCommand;
import oracle.ide.cmd.OpenCommandData;
import oracle.ide.net.URLFactory;
import org.jetbrains.annotations.NotNull;

public class CheckoutMdsProjectCommand
implements Command {
    private MdProject<? extends ProjectArtifact> mdsProject;

    public CheckoutMdsProjectCommand(MdProject<? extends ProjectArtifact> mdsProject) {
        this.mdsProject = mdsProject;
    }

    @Override
    public Object execute() {
        Project project;
        try {
            project = (Project)this.mdsProject.getProject().get();
            URI baseLocation = new File(this.getRootDir()).toURI();
            this.openCheckedOutProject(project, baseLocation);
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logMessage(e.getStackTraceString());
            throw new ExecutionException(e);
        }
        catch (ProjectException e) {
            MdsLogger.getInstance().logMessage(e.getStackTraceString());
            throw new ExecutionException(e);
        }
        return project;
    }

    @Override
    public String getName() {
        return "Checkout:" + this.getAffectedObject().getName();
    }

    public MdProject getAffectedObject() {
        return this.mdsProject;
    }

    @Override
    public void undo() {
    }

    private void openCheckedOutProject(Project project, URI baseLocation) throws ProjectException {
        try {
            File targetLocation = new File(new File(baseLocation), this.mdsProject.getName());
            VFileFilter fileFilter = new VFileFilter(){

                public boolean accept(@NotNull VFile pathName) {
                    return !pathName.getName().equals("project.lock");
                }
            };
            AbstractProjectRepository.copyProjectTo((Project)project, (File)targetLocation, (VFileFilter)fileFilter);
            FileProjectRepository fileRepository = FileProjectRepository.create((File)new File(baseLocation));
            Project fileSystemProject = fileRepository.create(baseLocation, this.mdsProject.getName());
            fileSystemProject.getWriter().write(new ProjectObject[]{fileSystemProject.getOrganization()});
            OpenCommand openCommand = new OpenCommand();
            openCommand.setContext(Context.newIdeContext());
            openCommand.setData((Object)new OpenCommandData(false));
            openCommand.openURL(URLFactory.newFileURL((File)new File(targetLocation, this.mdsProject.getName() + ".jpr")));
        }
        catch (ProjectException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw e;
        }
        catch (Exception e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new ProjectException((ProjectObject)project, FusionStudioMsg.CANNOT_OPEN_CHECKEDOUT_MDS_PROJECT);
        }
    }

    private String getRootDir() {
        return Ide.getActiveWorkspace().getBaseDirectory();
    }
}

