/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.action;

import java.awt.Component;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.action.AbstractMdsAction;
import oracle.bpm.fusion.soa.mds.command.RefreshMdsProjectCommand;
import oracle.bpm.fusion.soa.mds.command.UnlockMdsProjectCommand;
import oracle.bpm.fusion.soa.mds.model.MDSSecurityUtils;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.ide.Ide;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class UnlockMdsProjectAction
extends AbstractMdsAction {
    private PublicShareProject publicShareProject;

    public UnlockMdsProjectAction(PublicShareProject publicShareProject) {
        super(FusionStudioMsg.UNLOCK_PROJECT);
        this.requires(MdProject.class);
        this.publicShareProject = publicShareProject;
    }

    @Override
    public void actionPerformed() {
        this.unLockMdsProject();
    }

    private void unLockMdsProject() {
        if (!MDSSecurityUtils.hasUserLoggedLock(this.publicShareProject) && !this.publicShareProject.isManageable()) {
            MessageDialog.showError((Msg)FusionStudioMsg.LOCK_ACQUIRED_BY_ANOTHER_USER);
            return;
        }
        int answer = MessageDialog.showQuestion((Msg)FusionStudioMsg.UNLOCK_PROJECT, (Msg)FusionStudioMsg.ASK_CONFIRMATION_FOR_RELEASING_LOCK, (int)6);
        if (answer == 2) {
            FuegoWorker.post((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), FusionStudioMsg.UNLOCKING_BPM_MDS_PROJECT.toString());
                    progressMonitor.setCancellable(false);
                    progressMonitor.start();
                    try {
                        new UnlockMdsProjectCommand(UnlockMdsProjectAction.this.publicShareProject).execute();
                        new RefreshMdsProjectCommand().execute();
                    }
                    catch (ExecutionException e) {
                        MdsLogger.getInstance().logStackTrace(e);
                        MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_UNLOCKING_MDS_PROJECT((String)e.getMessage()));
                    }
                    finally {
                        progressMonitor.finish();
                    }
                }
            });
        }
    }
}

