/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.action;

import java.awt.Component;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.MdsProjectNavigatorManager;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.action.AbstractMdsAction;
import oracle.bpm.fusion.soa.mds.command.RefreshMdsProjectCommand;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.selection.Selection;
import oracle.ide.Ide;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class RefreshMdsProjectsAction
extends AbstractMdsAction {
    public RefreshMdsProjectsAction() {
        super(FusionStudioMsg.REFRESH);
        this.requires(Void.class);
    }

    @Override
    public void actionPerformed() {
        if (!StudioMetadataService.getInstance().isStatusConnected()) {
            MessageDialog.showWarning((Msg)FusionStudioMsg.CONNECTION_COULD_NOT_BE_STABLISHED);
        } else {
            FuegoWorker.post((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), FusionStudioMsg.REFRESHING_BPM_MDS_PROJECT.toString());
                    progressMonitor.setCancellable(false);
                    progressMonitor.start();
                    try {
                        new RefreshMdsProjectCommand().execute();
                    }
                    catch (ExecutionException e) {
                        MdsLogger.getInstance().logStackTrace(e);
                        MessageDialog.showError((Throwable)e);
                    }
                    finally {
                        progressMonitor.finish();
                    }
                }
            });
        }
        MdsProjectNavigatorManager.getInstance().getNavigatorWindow().updateVisibleActions();
    }

    protected void updateEnableStatus(Selection s) {
        this.setEnabled(StudioMetadataService.getInstance().isStatusConnected());
    }
}

