/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.action;

import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.action.AbstractMdsAction;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.lang.exception.ProgramException;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.ui.wizards.ExportFuegoProjectWizard;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;

public class ExportMdsProjectAction
extends AbstractMdsAction {
    private MdProject<? extends ProjectArtifact> mdsProject;

    public ExportMdsProjectAction() {
        super(FusionStudioMsg.EXPORT_MDS_PROJECT);
        this.requires(MdProject.class);
    }

    public ExportMdsProjectAction(MdProject<? extends ProjectArtifact> mdsProject) {
        this();
        this.mdsProject = mdsProject;
    }

    @Override
    public void actionPerformed() {
        this.exportProject();
    }

    private void exportProject() {
        if (!StudioMetadataService.getInstance().isStatusConnected()) {
            MessageDialog.showWarning((Msg)FusionStudioMsg.CONNECTION_COULD_NOT_BE_STABLISHED);
        } else {
            ExportFuegoProjectWizard exportWizard = new ExportFuegoProjectWizard(this.getProject(), true, FusionStudioMsg.EXPORT_MDS_PROJECT);
            exportWizard.run();
        }
    }

    private Project getProject() {
        try {
            return (Project)this.mdsProject.getProject().get();
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw ProgramException.wrap("Problems while getting the project from MDS.", e);
        }
    }
}

