/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.action;

import java.awt.Component;
import java.awt.Cursor;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.command.UpdateBpmRepositoryConnectionCommand;
import oracle.bpm.fusion.soa.mds.model.BPMConnectionDescriptor;
import oracle.bpm.fusion.soa.mds.ui.IndProgressMonitorRunnableDecorator;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.soa.mds.ui.NewRepositoryConnectionDialog;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.msg.UIMsg;
import oracle.ide.Ide;

public class EditBpmRepositoryConnectionAction
extends BaseAction {
    private BPMConnectionDescriptor bpmConnectionDescriptor;

    public EditBpmRepositoryConnectionAction(BPMConnectionDescriptor bpmConnectionDescriptor) {
        this.bpmConnectionDescriptor = bpmConnectionDescriptor;
    }

    public void run() {
        this.editConnection(this.bpmConnectionDescriptor);
    }

    private void editConnection(BPMConnectionDescriptor bpmConnectionDescriptor) {
        final NewRepositoryConnectionDialog repositoryConnectionDialog = new NewRepositoryConnectionDialog(bpmConnectionDescriptor, UIMsg.EDIT_SOMETHING((String)FusionStudioMsg.BPM_REPOSITORY_CONNECTION.getString()));
        boolean isOK = repositoryConnectionDialog.runDialog();
        if (isOK) {
            Runnable editConnectionRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    repositoryConnectionDialog.setCursor(Cursor.getPredefinedCursor(3));
                    BPMConnectionDescriptor editedBPMConnectionDescriptor = repositoryConnectionDialog.getConnection();
                    try {
                        new UpdateBpmRepositoryConnectionCommand(editedBPMConnectionDescriptor).execute();
                    }
                    catch (ExecutionException e) {
                        MdsLogger.getInstance().logStackTrace(e);
                        MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_UPDATING_BPM_CONNECTION, (Throwable)e);
                    }
                    finally {
                        repositoryConnectionDialog.setCursor(Cursor.getDefaultCursor());
                    }
                }
            };
            if (StudioMetadataService.getInstance().getCurrentConnection() != null && StudioMetadataService.getInstance().getCurrentConnection().getName().equals(bpmConnectionDescriptor.getName())) {
                IndProgressMonitorRunnableDecorator monitorRunnableDecorator = new IndProgressMonitorRunnableDecorator((Component)Ide.getMainWindow(), FusionStudioMsg.REFRESHING_BPM_MDS_PROJECT, editConnectionRunnable);
                monitorRunnableDecorator.run();
            } else {
                editConnectionRunnable.run();
            }
        }
    }
}

