/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.action;

import java.awt.Component;
import java.util.Collection;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.execution.ExecutionException;
import oracle.bpm.fusion.soa.mds.MdsProjectNavigatorManager;
import oracle.bpm.fusion.soa.mds.MdsProjectNode;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.action.AbstractMdsAction;
import oracle.bpm.fusion.soa.mds.command.DeleteMdsProjectCommand;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.LocalRef;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.ide.Ide;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class DeleteTemplateAction
extends AbstractMdsAction {
    private MdProject mdProject;
    private MdsProjectNode mdsProjectNode;

    public DeleteTemplateAction() {
        super(FusionStudioMsg.DELETE_MDS_PROJECT);
        this.requires(MdsProjectNode.class);
    }

    public DeleteTemplateAction(MdsProjectNode mdsProjectNode) {
        this();
        this.mdProject = mdsProjectNode.getObject();
        this.mdsProjectNode = mdsProjectNode;
    }

    @Override
    public void actionPerformed() {
        if (!this.mdProject.isTemplate()) {
            throw new IllegalArgumentException("Project to be deleted should be a " + TemplateProject.class);
        }
        this.deleteTemplate((TemplateProject)this.mdProject);
    }

    private void deleteTemplate(final TemplateProject templateProject) {
        boolean deleteAnyway;
        Collection linkedPublicShares;
        try {
            oracle.bpm.pml.service.StudioMetadataService metadataService = StudioMetadataService.getInstance().getService();
            linkedPublicShares = metadataService.getPublicSharesLinkedToTemplate(templateProject).toCollection(true);
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logStackTrace(e);
            MessageDialog.showError((Msg)e.getKey());
            return;
        }
        Msg deletionMsg = linkedPublicShares.isEmpty() ? DesignerMsg.CONFIRM_DELETION((String)templateProject.getName()) : FusionStudioMsg.CONFIRM_DELETION_WITH_LINKED_PUBLIC_SHARES((String)templateProject.getName(), (String)this.formatList(linkedPublicShares));
        boolean bl = deleteAnyway = MessageDialog.showQuestion((Msg)FusionStudioMsg.DELETE_MDS_PROJECT_TITLE, (Msg)deletionMsg, (int)6) == 2;
        if (deleteAnyway) {
            FuegoWorker.post((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), FusionStudioMsg.DELETING_PROJECT.toString());
                    progressMonitor.setCancellable(false);
                    progressMonitor.start();
                    try {
                        new DeleteMdsProjectCommand((MdProject)templateProject).execute();
                        MdsProjectNavigatorManager.getInstance().removeProjectArtifact(DeleteTemplateAction.this.mdsProjectNode);
                    }
                    catch (ExecutionException e) {
                        MdsLogger.getInstance().logStackTrace(e);
                        MessageDialog.showError((Msg)FusionStudioMsg.ERROR_WHILE_DELETING_MDS_PROJECT((String)e.getMessage()));
                    }
                    finally {
                        progressMonitor.finish();
                    }
                }
            });
        }
    }

    private String formatList(Collection<LocalRef<ProjectArtifact>> linkedPublicShares) {
        String result = "\n";
        for (LocalRef<ProjectArtifact> projectArtifact : linkedPublicShares) {
            result = result.concat("- " + projectArtifact.getName() + "\n");
        }
        return result.concat("\n");
    }
}

