/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.action;

import java.awt.Component;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.fusion.soa.mds.MdsFolderNode;
import oracle.bpm.fusion.soa.mds.MdsProjectNavigatorManager;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.action.AbstractMdsAction;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.ide.Ide;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class DeleteMdsFolderAction
extends AbstractMdsAction {
    private MdsFolderNode mdsFolderNode;
    private boolean wasDeleted = false;

    public DeleteMdsFolderAction(MdsFolderNode mdsFolderNode) {
        super(FusionStudioMsg.DELETE_FOLDER);
        this.requires(MdsFolderNode.class);
        this.mdsFolderNode = mdsFolderNode;
    }

    @Override
    public void actionPerformed() {
        this.deleteMdsFolder();
    }

    public boolean wasDeleted() {
        return this.wasDeleted;
    }

    private void deleteMdsFolder() {
        if (!StudioMetadataService.getInstance().isStatusConnected()) {
            MessageDialog.showWarning((Msg)FusionStudioMsg.CONNECTION_COULD_NOT_BE_STABLISHED);
        } else {
            int answer = MessageDialog.showQuestion((Msg)FusionStudioMsg.DELETE_FOLDER, (Msg)DesignerMsg.CONFIRM_DELETION((String)this.mdsFolderNode.getShortLabel()), (int)9);
            if (answer == 1) {
                FuegoWorker.post((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), FusionStudioMsg.DELETING_FOLDER.toString());
                        progressMonitor.setCancellable(false);
                        progressMonitor.start();
                        try {
                            StudioMetadataService.getInstance().getService().deleteFolder(DeleteMdsFolderAction.this.mdsFolderNode.getType().getClassType(), (ProjectFolder)DeleteMdsFolderAction.this.mdsFolderNode.as(ProjectFolder.class), true);
                            MdsProjectNavigatorManager.getInstance().removeProjectArtifact(DeleteMdsFolderAction.this.mdsFolderNode);
                            DeleteMdsFolderAction.this.wasDeleted = true;
                        }
                        catch (MetadataException e) {
                            MdsLogger.getInstance().logStackTrace(e);
                            MessageDialog.showError((Throwable)e);
                        }
                        finally {
                            progressMonitor.finish();
                        }
                    }
                });
            }
        }
    }
}

