/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds.action;

import java.util.HashSet;
import java.util.Set;
import oracle.bpm.fusion.soa.mds.MdsOperationContext;
import oracle.bpm.fusion.soa.mds.MdsOperationInterceptor;
import oracle.bpm.fusion.soa.mds.StudioMetadataService;
import oracle.bpm.fusion.soa.mds.action.ActionCancelledListener;
import oracle.bpm.fusion.soa.mds.action.ConfigureMdsConnectionAction;
import oracle.bpm.fusion.soa.mds.action.RefreshMdsProjectsAction;
import oracle.bpm.fusion.soa.mds.model.BpmConnectionException;
import oracle.bpm.fusion.soa.mds.model.BpmMdsException;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.DefaultSelection;
import oracle.bpm.ui.selection.Selection;
import oracle.ide.Context;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMdsAction
extends BaseAction {
    private Set<ActionCancelledListener> actionCancelledListeners = new HashSet<ActionCancelledListener>();

    public AbstractMdsAction(Msg msg) {
        super(msg);
    }

    public abstract void actionPerformed();

    public final void run() {
        MdsOperationContext context = new MdsOperationContext(StudioMetadataService.getInstance());
        if (this.isRequired(Void.class)) {
            context.setSelection(DefaultSelection.EMPTY);
        } else {
            context.setSelection(DefaultSelection.createSingle((Object)Context.newIdeContext().getElement()));
        }
        try {
            MdsOperationInterceptor.getInstance().operationInvoked(context);
            this.actionPerformed();
        }
        catch (BpmConnectionException e) {
            MdsLogger.getInstance().logStackTrace(e);
            ConfigureMdsConnectionAction configureConnectionAction = new ConfigureMdsConnectionAction();
            configureConnectionAction.run();
            if (!configureConnectionAction.isActionCancelled()) {
                try {
                    MdsOperationInterceptor.getInstance().operationInvoked(context);
                    this.actionPerformed();
                }
                catch (BpmConnectionException e1) {
                    MdsLogger.getInstance().logStackTrace(e);
                    MessageDialog.showError((Msg)FusionStudioMsg.MDS_CONNECTION_FAILED);
                }
                catch (BpmMdsException e1) {
                    MdsLogger.getInstance().logStackTrace(e);
                    MessageDialog.showError((Msg)e.getKey());
                }
            }
        }
        catch (BpmMdsException e) {
            MdsLogger.getInstance().logStackTrace(e);
            MessageDialog.showError((Msg)(e.getKey().equals(CoreMsg.NO_MESSAGE_CODE) ? UIMsg.TO_MSG((String)e.getMessage()) : e.getKey()));
            this.fireOperationCancelled();
            new RefreshMdsProjectsAction().run();
        }
    }

    public void addActionCancelledListener(@NotNull ActionCancelledListener l) {
        if (l == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/action/AbstractMdsAction.addActionCancelledListener must not be null");
        }
        this.actionCancelledListeners.add(l);
    }

    public void removeActionCancelledListener(ActionCancelledListener l) {
        this.actionCancelledListeners.remove(l);
    }

    public final void runWithSelection(Selection selection) {
        this.setSelection(selection);
        this.run();
    }

    private void fireOperationCancelled() {
        for (ActionCancelledListener l : this.actionCancelledListeners) {
            l.actionCancelled();
        }
    }
}

