/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds;

import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.resources.Msg;

public class MdsUiUtils {
    public static String getStatusInformationFor(MdProject mdProject) {
        return "<html><font size=\"2\" face=\"times\"><p\">" + MdsUiUtils.getProjectNameInfo(mdProject) + MdsUiUtils.getUserRoleInfo(mdProject) + MdsUiUtils.getProjectStatusInfo(mdProject) + MdsUiUtils.getProjectLockInfo(mdProject) + "</p>" + "</font><html>";
    }

    private static String getUserRoleInfo(MdProject mdProject) {
        String roleInfo;
        if (mdProject.isOwner()) {
            Msg ownerRoleMsg = FusionStudioMsg.OWNER_ROLE;
            roleInfo = "<img src=\"" + ownerRoleMsg.getImageResource().toString() + "\" />&nbsp;&nbsp;" + FusionStudioMsg.ROLE + ":&nbsp;<b>" + ownerRoleMsg + "</b><br/>";
        } else if (mdProject.isManageable()) {
            Msg adminRoleMsg = FusionStudioMsg.ADMIN_ROLE;
            roleInfo = "<img src=\"" + adminRoleMsg.getImageResource().toString() + "\" />&nbsp;" + FusionStudioMsg.ROLE + ":&nbsp;<b>" + adminRoleMsg + "</b><br/>";
        } else if (mdProject.isEditable()) {
            Msg editorRoleMsg = FusionStudioMsg.EDITOR_ROLE;
            roleInfo = "<img src=\"" + editorRoleMsg.getImageResource().toString() + "\" />&nbsp;" + FusionStudioMsg.ROLE + ":&nbsp;<b>" + editorRoleMsg + "</b><br/>";
        } else {
            Msg viewerRoleMsg = FusionStudioMsg.VIEWER_ROLE;
            roleInfo = "<img src=\"" + viewerRoleMsg.getImageResource().toString() + "\" />&nbsp;" + FusionStudioMsg.ROLE + ":&nbsp;<b>" + viewerRoleMsg + "</b><br/>";
        }
        return roleInfo;
    }

    private static String getProjectNameInfo(MdProject mdProject) {
        String nameInfo = mdProject.isPublicShare() ? "<img src=\"" + FusionStudioMsg.PUBLIC_SHARE_PROJECT.getImageResource().toString() + "\" />" : "<img src=\"" + FusionStudioMsg.TEMPLATE_PROJECT.getImageResource().toString() + "\" />";
        return nameInfo + "&nbsp;" + FusionStudioMsg.NAME + ":&nbsp;<b>" + mdProject.getName() + "&nbsp;</b><br/>";
    }

    private static String getProjectStatusInfo(MdProject mdProject) {
        String statusInfo = "";
        if (mdProject.isPublicShare()) {
            PublicShareProject publicShare = (PublicShareProject)mdProject;
            if (publicShare.isShared()) {
                Msg sharedMsg = FusionStudioMsg.SHARED;
                statusInfo = "<img src=\"" + sharedMsg.getImageResource().toString() + "\" />&nbsp;" + FusionStudioMsg.STATUS + ":&nbsp;<b>" + sharedMsg + "</b><br/>";
            } else {
                Msg privateMsg = FusionStudioMsg.PRIVATE;
                statusInfo = "<img src=\"" + privateMsg.getImageResource().toString() + "\" />&nbsp;" + FusionStudioMsg.STATUS + ":&nbsp;<b>" + privateMsg + "</b><br/>";
            }
        }
        return statusInfo;
    }

    private static String getProjectLockInfo(MdProject mdProject) {
        PublicShareProject publicShare;
        String lockInfo = "";
        if (mdProject.isPublicShare() && (publicShare = (PublicShareProject)mdProject).isLocked()) {
            Msg lockMsg = FusionStudioMsg.LOCKED_BY;
            lockInfo = "<img src=\"" + lockMsg.getImageResource().toString() + "\" />&nbsp;" + lockMsg + "&nbsp;<b>" + publicShare.getUserLock() + "</b>";
        }
        return lockInfo;
    }
}

