/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds;

import oracle.bpm.adapter.Adaptable;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.fusion.soa.mds.MdsArtifactType;
import oracle.bpm.fusion.soa.mds.MdsProjectNode;
import oracle.bpm.fusion.soa.mds.action.CheckoutMdsProjectAction;
import oracle.bpm.fusion.soa.mds.action.DeletePublicShareAction;
import oracle.bpm.fusion.soa.mds.action.DeleteTemplateAction;
import oracle.bpm.fusion.soa.mds.action.ExportMdsProjectAction;
import oracle.bpm.fusion.soa.mds.action.LockMdsProjectAction;
import oracle.bpm.fusion.soa.mds.action.ShowProjectHistoryAction;
import oracle.bpm.fusion.soa.mds.action.ShowProjectSnapshotsAction;
import oracle.bpm.fusion.soa.mds.action.UnlockMdsProjectAction;
import oracle.bpm.fusion.soa.mds.model.MDSSecurityUtils;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectArtifact;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;

@ActionGroupMetadata(target=MdsProjectNode.class)
public class MdsProjectNodeActionGroupFactory
implements ActionGroupFactory {
    public ActionGroup create(Adaptable context) {
        MdsProjectNode mdsProjectNode = context.as(MdsProjectNode.class);
        MdProject mdProject = (MdProject)mdsProjectNode.as(MdProject.class);
        ActionGroup actionGroup = new ActionGroup();
        actionGroup.add((BaseAction)new CheckoutMdsProjectAction((MdProject<? extends ProjectArtifact>)mdProject));
        if (MdsArtifactType.PUBLIC_SHARE == mdsProjectNode.getType()) {
            PublicShareProject publicShareProject = (PublicShareProject)mdsProjectNode.as(PublicShareProject.class);
            if (!publicShareProject.isLocked() && publicShareProject.isEditable()) {
                actionGroup.add((BaseAction)new LockMdsProjectAction(publicShareProject));
            } else if (publicShareProject.isEditable() && MDSSecurityUtils.hasUserLoggedLock(publicShareProject) || publicShareProject.isManageable()) {
                actionGroup.add((BaseAction)new UnlockMdsProjectAction(publicShareProject));
            }
            actionGroup.add((BaseAction)new ShowProjectSnapshotsAction(mdsProjectNode));
        }
        actionGroup.add((BaseAction)new ExportMdsProjectAction((MdProject<? extends ProjectArtifact>)mdProject));
        actionGroup.add((BaseAction)new ShowProjectHistoryAction((MdProject<? extends ProjectArtifact>)mdProject));
        if (mdProject.isManageable()) {
            if (mdProject.isPublicShare()) {
                actionGroup.add((BaseAction)new DeletePublicShareAction(mdsProjectNode));
            } else {
                actionGroup.add((BaseAction)new DeleteTemplateAction(mdsProjectNode));
            }
        }
        return actionGroup;
    }
}

