/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds;

import java.net.URL;
import javax.swing.Icon;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.fusion.core.model.AbstractNodeAdapter;
import oracle.bpm.fusion.soa.mds.IMdsNode;
import oracle.bpm.fusion.soa.mds.MdsArtifactType;
import oracle.bpm.fusion.soa.mds.MdsFolderNode;
import oracle.bpm.fusion.soa.mds.MdsUiUtils;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.PublicShareProject;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.ActionGroup;
import org.jetbrains.annotations.NotNull;

public class MdsProjectNode
extends AbstractNodeAdapter<MdProject>
implements IMdsNode<MdProject> {
    private MdProject mdProject;
    private MdsFolderNode parent;

    public MdsProjectNode(@NotNull MdProject mdProject, URL url) {
        if (mdProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/mds/MdsProjectNode.<init> must not be null");
        }
        super(url);
        this.mdProject = mdProject;
    }

    public Icon getIcon() {
        PublicShareProject publicShareProject;
        Msg msg = this.getType() == MdsArtifactType.TEMPLATE ? DesignerMsg.PROJECT_TEMPLATE : DesignerMsg.PROJECT;
        Image icon = Image.create((Msg)msg);
        if (this.getType() == MdsArtifactType.PUBLIC_SHARE && (publicShareProject = (PublicShareProject)this.getObject()).isLocked()) {
            icon = icon != null ? IconFactory.createReadOnly((Image)icon) : null;
        }
        return icon != null ? icon.asSwingIcon() : null;
    }

    @Override
    public MdsFolderNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(MdsFolderNode mdsFolderNode) {
        this.parent = mdsFolderNode;
    }

    @Override
    public MdsArtifactType getType() {
        if (TemplateProject.class.isAssignableFrom(this.getObject().getClass())) {
            return MdsArtifactType.TEMPLATE;
        }
        return MdsArtifactType.PUBLIC_SHARE;
    }

    public ActionGroup createActions() {
        return ActionGroup.create((Object)this);
    }

    public MdProject getObject() {
        return this.mdProject;
    }

    public void replaceObject(MdProject replacement) {
    }

    public void invalidateIcon() {
    }

    public String getToolTipText() {
        return MdsUiUtils.getStatusInformationFor(this.mdProject);
    }
}

