/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.mds;

import oracle.bpm.fusion.soa.mds.MdsFolderNode;
import oracle.bpm.fusion.soa.mds.MdsOperationContext;
import oracle.bpm.fusion.soa.mds.MdsProjectNode;
import oracle.bpm.fusion.soa.mds.model.BpmConnectionException;
import oracle.bpm.fusion.soa.mds.model.BpmMdsException;
import oracle.bpm.fusion.soa.mds.ui.MdsLogger;
import oracle.bpm.fusion.studio.msg.FusionStudioMsg;
import oracle.bpm.metadata.entity.MdProject;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.exception.ProjectNotFoundException;
import oracle.bpm.ui.selection.Selection;

public class MdsOperationInterceptor {
    private static MdsOperationInterceptor instance;

    public static synchronized MdsOperationInterceptor getInstance() {
        if (instance == null) {
            instance = new MdsOperationInterceptor();
        }
        return instance;
    }

    public void operationInvoked(MdsOperationContext context) throws BpmConnectionException, BpmMdsException {
        this.checkConnection(context);
        this.checkArtifact(context);
    }

    private void checkConnection(MdsOperationContext context) throws BpmConnectionException {
        if (!context.getMetadataService().isStatusConnected()) {
            throw new BpmConnectionException(FusionStudioMsg.MDS_CONNECTION_FAILED);
        }
    }

    private void checkArtifact(MdsOperationContext context) throws BpmMdsException {
        Selection selection = context.getSelection();
        if (!selection.isEmpty()) {
            MdsProjectNode mdsProjectNode = (MdsProjectNode)selection.as(MdsProjectNode.class);
            if (mdsProjectNode != null) {
                this.checkProjectExistence(context, mdsProjectNode);
            } else {
                MdsFolderNode folderNode = (MdsFolderNode)selection.as(MdsFolderNode.class);
                if (folderNode != null && !folderNode.isDefault()) {
                    this.checkFolderExistence(context, folderNode);
                }
            }
        }
    }

    private void checkProjectExistence(MdsOperationContext context, MdsProjectNode mdsProjectNode) throws BpmMdsException {
        MdProject mdProject = (MdProject)mdsProjectNode.as(MdProject.class);
        try {
            context.getMetadataService().getService().loadProject(mdsProjectNode.getType().getClassType(), mdProject.getId(), true);
        }
        catch (ProjectNotFoundException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmMdsException(FusionStudioMsg.MDS_ARTIFACT_DOES_NOT_EXISTS_ANYMORE((String)FusionStudioMsg.PROJECT.getString(), (String)mdProject.getName()));
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmMdsException(e.getMessage());
        }
    }

    private void checkFolderExistence(MdsOperationContext context, MdsFolderNode mdsFolderNode) throws BpmMdsException {
        try {
            ProjectFolder projectFolder = (ProjectFolder)mdsFolderNode.as(ProjectFolder.class);
            boolean existsFolder = context.getMetadataService().getService().existsFolder(mdsFolderNode.getType().getClassType(), projectFolder);
            if (!existsFolder) {
                throw new BpmMdsException(FusionStudioMsg.MDS_ARTIFACT_DOES_NOT_EXISTS_ANYMORE((String)FusionStudioMsg.FOLDER.getString(), (String)mdsFolderNode.getShortLabel()));
            }
        }
        catch (MetadataException e) {
            MdsLogger.getInstance().logStackTrace(e);
            throw new BpmMdsException(e.getMessage());
        }
    }
}

