/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.identity;

import oracle.bpm.designer.identity.LookupDialog;
import org.jetbrains.annotations.NotNull;

public class LookupDialogImpl
implements LookupDialog {
    private LookupDialog.LookupDialogType type;
    private String value;

    public LookupDialogImpl(@NotNull LookupDialog.LookupDialogType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/identity/LookupDialogImpl.<init> must not be null");
        }
        this.type = type;
    }

    public boolean showDialog() {
        boolean result = false;
        boolean lookupType = false;
        int dialogType = this.getDialogType();
        oracle.tip.tools.ide.fabric.lookup.LookupDialog dialog = new oracle.tip.tools.ide.fabric.lookup.LookupDialog(0, null, dialogType);
        if (dialog.showDialog()) {
            this.setValueFromDialog(dialog);
            result = true;
        }
        return result;
    }

    public String getValue() {
        return this.value;
    }

    private int getDialogType() {
        int result = oracle.tip.tools.ide.fabric.lookup.LookupDialog.DEFAULT_LOOKUP;
        switch (this.type) {
            case USER: {
                result = oracle.tip.tools.ide.fabric.lookup.LookupDialog.DEFAULT_LOOKUP;
                break;
            }
            case EMAIL: {
                result = oracle.tip.tools.ide.fabric.lookup.LookupDialog.EMAIL_LOOKUP;
                break;
            }
            case PHONE_NUMBER: {
                result = oracle.tip.tools.ide.fabric.lookup.LookupDialog.VOICE_LOOKUP;
                break;
            }
            case IM_ID: {
                result = oracle.tip.tools.ide.fabric.lookup.LookupDialog.IM_LOOKUP;
            }
        }
        return result;
    }

    private void setValueFromDialog(@NotNull oracle.tip.tools.ide.fabric.lookup.LookupDialog dialog) {
        if (dialog == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/identity/LookupDialogImpl.setValueFromDialog must not be null");
        }
        switch (this.type) {
            case USER: {
                this.value = dialog.getSelectedPrinciple();
                break;
            }
            case EMAIL: {
                this.value = dialog.getEmailAddress();
                break;
            }
            case PHONE_NUMBER: {
                this.value = dialog.getPhoneNumber();
                break;
            }
            case IM_ID: {
                this.value = dialog.getIMId();
            }
        }
    }
}

