/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.humantask;

import java.awt.Component;
import java.net.URL;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.Tuple;
import oracle.bpm.designer.HumanTaskData;
import oracle.bpm.designer.HumanTaskPreferences;
import oracle.bpm.fusion.soa.humantask.HumanTaskInfo;
import oracle.bpm.fusion.soa.humantask.HumanTaskPanel;
import oracle.bpm.fusion.soa.humantask.HumanTaskUtils;
import oracle.bpm.project.model.catalog.HumanTask;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.ide.model.Project;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;
import oracle.tip.tools.ide.workflow.editor.data.WFEditorData;
import oracle.tip.tools.ide.workflow.projectwizard.WizardData;
import oracle.tip.tools.ide.workflow.util.WorkflowResourceUtil;

class HumanTaskDialog
extends OkCancelDialog {
    private HumanTaskData humanTaskData;
    private HumanTaskPanel humanTaskPanel;
    private UserTask userTask;
    private static final String HUMANTASK = "Humantask";

    public HumanTaskDialog(UiWindow parent, UserTask userTask, HumanTaskPreferences humanTaskPreferences) {
        super(parent, ProjectUiMsg.CREATE((Msg)ProjectModelMsg.HUMAN_TASK));
        this.userTask = userTask;
        this.init(humanTaskPreferences);
    }

    public void ok() {
        if (this.humanTaskPanel.validateData()) {
            final StatusGlassPane glass = new StatusGlassPane((Component)this.getContentPane().asSwing());
            glass.setVisibilityDelay(0);
            glass.enableUserInput(false);
            glass.setStatusMessage(WorkflowResourceUtil.getString((String)"PLEASE_WAIT") + "...", WorkflowResourceUtil.getString((String)"WF_CREATING_TASK"));
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        WizardData data = HumanTaskDialog.this.humanTaskPanel.getWizardData();
                        WFEditorData editorData = HumanTaskDialog.this.humanTaskPanel.getWFEditorData();
                        HumanTaskInfo humanTaskInfo = HumanTaskDialog.this.humanTaskPanel.getHumanTaskInfo();
                        try {
                            HumanTask humanTask = HumanTaskUtils.createHumanTask(HumanTaskDialog.this.getProject(), data, editorData, humanTaskInfo);
                            Sequence<Tuple<String, String>> inputParameters = humanTaskInfo.getInputParameters();
                            Sequence<Tuple<String, String>> outputParameters = humanTaskInfo.getOutputParameters();
                            HumanTaskData humanTaskData = new HumanTaskData(humanTask, inputParameters, outputParameters);
                            HumanTaskDialog.this.setHumanTaskData(humanTaskData);
                            HumanTaskDialog.this.closeDialog(true);
                        }
                        catch (ProjectException e) {
                            MessageDialog.showError((Msg)e.getMsg(), (Throwable)e);
                            HumanTaskDialog.this.closeDialog(false);
                        }
                    }
                    finally {
                        glass.enableUserInput(true);
                    }
                }
            };
            new Thread(r).start();
        }
    }

    HumanTaskData getHumanTaskData() {
        return this.humanTaskData;
    }

    private void setHumanTaskData(HumanTaskData humanTaskData) {
        this.humanTaskData = humanTaskData;
    }

    private oracle.bpm.project.model.Project getProject() {
        return this.userTask.getProject();
    }

    private Project getJDevProject() {
        Project result = null;
        oracle.bpm.project.model.Project project = this.getProject();
        if (project instanceof Adaptable) {
            Adaptable adaptable = (Adaptable)project;
            result = adaptable.as(Project.class);
        }
        return result;
    }

    private void closeDialog(final boolean isOk) {
        UiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                HumanTaskDialog.this.setUserAccepted(isOk);
                HumanTaskDialog.this.close();
            }
        });
    }

    private void init(HumanTaskPreferences humanTaskPreferences) {
        UiContainer parent = this.getContentPane();
        this.humanTaskPanel = new HumanTaskPanel(parent, this.userTask, humanTaskPreferences, this.createUniqueName());
        parent.add((UiComponent)this.humanTaskPanel, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private String createUniqueName() {
        DefaultNameGenerator nameGen = new DefaultNameGenerator(HUMANTASK, ".task", 1);
        URL projDir = URLFactory.newDirURL((String)this.getJDevProject().getBaseDirectory());
        String name = URLFileSystem.getFileName((URL)URLFactory.newUniqueURL((URL)projDir, (NameGenerator)nameGen));
        if (name.endsWith(".task")) {
            name = name.substring(0, name.length() - ".task".length());
        }
        return name;
    }
}

