/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.controller;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.JFrame;
import oracle.bpm.designer.SpringWsdlInterface;
import oracle.bpm.fusion.repository.FusionProjectRepository;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.io.fs.VEventType;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileEvent;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.model.ProjectFileSystem;
import oracle.bpm.project.model.ProjectLoader;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiContainer;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.fabric.api.InterfaceInfo;
import oracle.tip.tools.ide.fabric.api.JavaInterfaceInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.fabric.api.SCAControllerInterfaceImpl;
import oracle.tip.tools.ide.fabric.api.SCAInterface;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.fabric.config.InterfaceConversionType;
import oracle.tip.tools.ide.fabric.config.SCAConfig;
import org.jetbrains.annotations.NotNull;

public class SpringWsdlInterfaceImpl
implements SpringWsdlInterface {
    private static final String WSDL = ".wsdl";
    private static SpringWsdlInterfaceImpl instance;

    private SpringWsdlInterfaceImpl() {
    }

    public static SpringWsdlInterfaceImpl getInstance() {
        if (instance == null) {
            instance = new SpringWsdlInterfaceImpl();
        }
        return instance;
    }

    public void updateWsdlInterface(@NotNull CatalogObject service) {
        SCAConfig scaconfig;
        InterfaceConversionType conversionType;
        if (service == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/controller/SpringWsdlInterfaceImpl.updateWsdlInterface must not be null");
        }
        if (service.isSpringService() && (conversionType = (scaconfig = SCAConfig.getSCAConfig()).getInterfaceConversionTypeByTypes("java", "wsdl")) != null) {
            oracle.bpm.project.model.Project projectModel = service.getProject();
            FusionProjectRepository fusionProjectRepository = (FusionProjectRepository)RepositoryService.getInstance().getActiveRepository();
            Project project = fusionProjectRepository.getJDevProject(projectModel);
            ObjectTypeDescription type = service.getObjectType();
            if (type != null) {
                Context context;
                JFrame frame;
                SCAInterface wsdlInfo;
                String target = type.getProperty("target");
                String targetPort = type.getProperty("target.port");
                SCAController scaController = SCAControllerImpl.getController((Project)project);
                InterfaceInfo javaInfo = scaController.getInterfaceInfoForName(target, targetPort);
                if (javaInfo != null && (wsdlInfo = SCAControllerInterfaceImpl.convertInterface((Frame)(frame = GraphUtils.getFrame((Component)(context = Context.newIdeContext()).getView().getGUI())), (Project)project, (SCAInterface)javaInfo, (InterfaceConversionType)conversionType, null)) != null) {
                    if (this.isValidFile((SCAInterface)javaInfo, wsdlInfo)) {
                        this.reloadComponent(projectModel, wsdlInfo);
                    } else {
                        MessageDialog.showError((UiContainer)Ui.getRoot(), (Msg)FusionSoaMsg.UPDATE_WSDL_INTERFACE, (Msg)FusionSoaMsg.INVALID_SPRING_INTERFACE_FILE);
                    }
                }
            }
        }
    }

    private boolean isValidFile(@NotNull SCAInterface javaInterface, @NotNull SCAInterface wsdlInterface) {
        if (javaInterface == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/controller/SpringWsdlInterfaceImpl.isValidFile must not be null");
        }
        if (wsdlInterface == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/controller/SpringWsdlInterfaceImpl.isValidFile must not be null");
        }
        assert (javaInterface instanceof JavaInterfaceInfo && wsdlInterface instanceof WsdlInfo);
        JavaInterfaceInfo javaInfo = (JavaInterfaceInfo)javaInterface;
        WsdlInfo wsdlInfo = (WsdlInfo)wsdlInterface;
        return (javaInfo.getJavaInterfaceName() + WSDL).endsWith(wsdlInfo.getWsdlLocation());
    }

    private void reloadComponent(oracle.bpm.project.model.Project projectModel, SCAInterface scaInterface) {
        ProjectLoader loader;
        String location;
        if (scaInterface != null && (location = ((WsdlInfo)scaInterface).getWsdlLocation()) != null && (loader = projectModel.getLoader()) != null) {
            ProjectFileSystem projectFileSystem = loader.getProjectFileSystem();
            VFileSystem system = projectFileSystem.getDataFileSystem();
            VFile file = system.createFile(location);
            system.fireEvent(new VFileEvent(VEventType.ADD, file));
        }
    }
}

