/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.controller;

import java.awt.Component;
import javax.swing.JFrame;
import oracle.bpm.designer.CustomizeService;
import oracle.bpm.fusion.soa.ui.extension.BusinessCatalogPromotionDialog;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import org.jetbrains.annotations.NotNull;

public class CustomizeServiceImpl
implements CustomizeService {
    private static CustomizeServiceImpl instance;

    private CustomizeServiceImpl() {
    }

    public static CustomizeServiceImpl getInstance() {
        if (instance == null) {
            instance = new CustomizeServiceImpl();
        }
        return instance;
    }

    public void customizeService(@NotNull CatalogObject service) {
        if (service == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/controller/CustomizeServiceImpl.customizeService must not be null");
        }
        Context context = this.findContext(service);
        JFrame frame = GraphUtils.getFrame((Component)context.getView().getGUI());
        new BusinessCatalogPromotionDialog(frame, service);
    }

    private Context findContext(CatalogObject service) {
        oracle.bpm.project.model.Project project = service.getProject();
        Project jDevProject = CustomizeServiceImpl.getJDevProject(project);
        return Context.newIdeContext((Node)jDevProject);
    }

    public void editCustomizedService(@NotNull CatalogObject service) {
        if (service == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/controller/CustomizeServiceImpl.editCustomizedService must not be null");
        }
        if (service.isService()) {
            Context context = this.findContext(service);
            JFrame frame = GraphUtils.getFrame((Component)context.getView().getGUI());
            new BusinessCatalogPromotionDialog(frame, service, true);
        }
    }

    private static Project getJDevProject(oracle.bpm.project.model.Project project) {
        return Platform.getAdapterService().adaptTo(project, Project.class);
    }
}

