/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.bpm.fusion.soa.customization.CustomizableArgument;
import oracle.bpm.fusion.soa.customization.CustomizableBPMObjectData;
import oracle.bpm.fusion.soa.customization.CustomizableOperation;
import oracle.bpm.fusion.soa.customization.CustomizableOperationError;
import oracle.bpm.fusion.soa.customization.CustomizedServiceBuilder;
import oracle.bpm.fusion.soa.customization.CustomizedServiceUpdater;
import oracle.bpm.fusion.soa.model.OperationInfo;
import oracle.bpm.fusion.soa.model.OperationsTableModel;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.fusion.soa.util.AdapterExtensionUtil;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Str;
import oracle.bpm.project.CatalogServiceUtil;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.type.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class AdapterExtensionProvider {
    @NotNull
    private List<CustomizableOperation> allOperations;
    @NotNull
    private CustomizableBPMObjectData customizableBpmObjectData;
    private Collection<CustomizableOperation> customizableOperations;
    private Boolean editMode;
    private Collection<CustomizableOperation> operationCollection;
    @NotNull
    private Project projectRef;
    private String serviceDescription;
    private CatalogObject serviceObject;
    private CustomizedServiceUpdater updater;

    public AdapterExtensionProvider(@NotNull CatalogObject interfaceObject, Boolean eMode) {
        if (interfaceObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/controller/AdapterExtensionProvider.<init> must not be null");
        }
        this.editMode = eMode;
        if (this.editMode.booleanValue()) {
            this.updater = CustomizedServiceUpdater.createCustomizedServiceUpdater(interfaceObject.asInterfaceObject());
            this.customizableBpmObjectData = this.updater.getCustomizedObjectData();
            this.customizableOperations = this.updater.getCustomizedOperations();
            this.operationCollection = this.updater.getNonCustomizedOperations();
        }
        this.projectRef = interfaceObject.getProject();
        this.serviceObject = interfaceObject;
    }

    public String getModule() {
        return this.serviceObject.getDelegate().getParent().getText();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public AbstractTableModel getOperationsTableModel() {
        this.populateOperations();
        int operationTableSize = this.allOperations.size();
        for (CustomizableOperation operation : this.allOperations) {
            operationTableSize = operationTableSize + operation.getCustomizedArguments().size() + operation.getOperationErrors().size();
        }
        OperationsTableModel operationsTableModel = new OperationsTableModel(operationTableSize);
        int rownum = 0;
        Iterator<CustomizableOperation> i$ = this.allOperations.iterator();
        while (true) {
            Iterator<Object> i$2;
            CustomizableOperation operation;
            if (i$.hasNext()) {
                operation = i$.next();
                if (this.editMode.booleanValue()) {
                    Boolean isPromoted = false;
                    for (CustomizableOperation promOper : this.customizableOperations) {
                        if (!promOper.getDisplayName().equals(operation.getDisplayName())) continue;
                        isPromoted = true;
                    }
                    if (isPromoted.booleanValue()) {
                        ((AbstractTableModel)operationsTableModel).setValueAt(Boolean.TRUE, rownum, 0);
                    } else {
                        ((AbstractTableModel)operationsTableModel).setValueAt(Boolean.FALSE, rownum, 0);
                    }
                } else {
                    ((AbstractTableModel)operationsTableModel).setValueAt(Boolean.TRUE, rownum, 0);
                }
                ((AbstractTableModel)operationsTableModel).setValueAt(operation.getDescription(), rownum, 4);
                OperationInfo opInfo = new OperationInfo(operation.getDelegatedOperation().getName(), operation.isCallback());
                opInfo.setDisplayName(operation.getDisplayName());
                ((AbstractTableModel)operationsTableModel).setValueAt(opInfo, rownum, 1);
                i$2 = operation.getCustomizedArguments().iterator();
            } else {
                OperationsTableModel operationsTableModel2 = operationsTableModel;
                if (operationsTableModel2 == null) {
                    throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/soa/controller/AdapterExtensionProvider.getOperationsTableModel must not return null");
                }
                return operationsTableModel2;
            }
            while (i$2.hasNext()) {
                CustomizableArgument argument = (CustomizableArgument)i$2.next();
                ((AbstractTableModel)operationsTableModel).setValueAt(null, ++rownum, 0);
                if (argument.isIn()) {
                    ((AbstractTableModel)operationsTableModel).setValueAt(FusionSoaMsg.IN_ARGUMENT_PREFIX + argument.getArgumentName(), rownum, 2);
                } else if (argument.isOut()) {
                    ((AbstractTableModel)operationsTableModel).setValueAt(FusionSoaMsg.OUT_ARGUMENT_PREFIX + argument.getArgumentName(), rownum, 2);
                }
                ((AbstractTableModel)operationsTableModel).setValueAt(argument.getArgumentTypeRef().getText(), rownum, 3);
                ((AbstractTableModel)operationsTableModel).setValueAt(argument.getDescription(), rownum, 4);
            }
            for (CustomizableOperationError error : operation.getOperationErrors()) {
                ((AbstractTableModel)operationsTableModel).setValueAt(null, ++rownum, 0);
                ((AbstractTableModel)operationsTableModel).setValueAt(FusionSoaMsg.BUS_OBJ_ERROR_PREFIX + error.getOriginalErrorType().getName(), rownum, 2);
                ((AbstractTableModel)operationsTableModel).setValueAt(error.getBpmObjectError().getText(), rownum, 3);
                ((AbstractTableModel)operationsTableModel).setValueAt(error.getErrorDescription(), rownum, 4);
            }
            ++rownum;
        }
    }

    public void createDelegatedBpmObjectData(@NotNull String name, @NotNull String module, @NotNull String description) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/controller/AdapterExtensionProvider.createDelegatedBpmObjectData must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/fusion/soa/controller/AdapterExtensionProvider.createDelegatedBpmObjectData must not be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/fusion/soa/controller/AdapterExtensionProvider.createDelegatedBpmObjectData must not be null");
        }
        if (!this.editMode.booleanValue()) {
            this.customizableBpmObjectData = CustomizableBPMObjectData.createCustomizableBPMObjectData(module, name, description, this.serviceObject);
        } else {
            this.serviceDescription = description;
        }
    }

    public void populateBusinessCatalog(@NotNull AbstractTableModel opnsTableModel) {
        if (opnsTableModel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/controller/AdapterExtensionProvider.populateBusinessCatalog must not be null");
        }
        ArrayList<CustomizableOperation> promotedOperations = new ArrayList<CustomizableOperation>();
        Boolean operationSelected = false;
        int opertationIndex = 0;
        for (int i = 0; i < opnsTableModel.getRowCount(); ++i) {
            if (opnsTableModel.getValueAt(i, 1) != null) {
                operationSelected = opnsTableModel.getValueAt(i, 0).equals(Boolean.TRUE);
                ++opertationIndex;
            } else {
                operationSelected = false;
            }
            if (!operationSelected.booleanValue()) continue;
            CustomizableOperation operation = this.allOperations.get(opertationIndex - 1);
            OperationInfo opnInfo = (OperationInfo)opnsTableModel.getValueAt(i, 1);
            boolean isOperationCallback = operation.isCallback();
            boolean isTableOperationCallback = opnInfo.belongsToCallbackPortType();
            String displayName = opnInfo.getDisplayName();
            String opnDescription = (String)opnsTableModel.getValueAt(i, 4);
            if (!Str.isEmpty(displayName.trim())) {
                operation.setDisplayName(displayName);
            }
            operation.setDescription(opnDescription);
            for (CustomizableArgument delegatedArgument : operation.getCustomizedArguments()) {
                String argDescription = (String)opnsTableModel.getValueAt(++i, 4);
                delegatedArgument.setDescription(argDescription);
            }
            for (CustomizableOperationError customizableOperationError : operation.getOperationErrors()) {
                String errorDescription = (String)opnsTableModel.getValueAt(++i, 4);
                customizableOperationError.setErrorDescription(errorDescription);
            }
            promotedOperations.add(operation);
        }
        CustomizableOperation[] operationsArray = promotedOperations.toArray(new CustomizableOperation[promotedOperations.size()]);
        this.addToBusinessCatalog(operationsArray);
    }

    public void addToBusinessCatalog(CustomizableOperation[] operations) {
        try {
            if (this.editMode.booleanValue()) {
                this.updater.updateServiceObjectData(this.serviceDescription, operations);
            } else {
                CustomizedServiceBuilder builder = CustomizedServiceBuilder.create(this.projectRef, this.customizableBpmObjectData, operations);
                builder.addToBusinessCatalog();
            }
        }
        catch (TypeCatalogException exc) {
            System.out.println("TypeCatalogException :\n" + exc.getMessage());
        }
    }

    public boolean isUniqueBpmObject(String bpmObjectName, String bpmObjectModule) throws TypeCatalogException {
        MutableComponentCatalog componentCatalog = AdapterExtensionUtil.getComponentCatalog(this.projectRef);
        ObjectTypeDescription root = componentCatalog.getRoot();
        ObjectTypeDescription parentModule = TypeUtils.createParentFromModule((ObjectTypeDescription)root, (String)bpmObjectModule, null);
        return !parentModule.hasInnerType(bpmObjectName);
    }

    private void populateOperations() {
        this.allOperations = new ArrayList<CustomizableOperation>();
        if (this.editMode.booleanValue()) {
            this.allOperations.addAll(this.customizableOperations);
            this.allOperations.addAll(this.operationCollection);
        } else {
            this.allOperations = this.getOperations(this.serviceObject);
            CatalogObject callbackService = CatalogServiceUtil.getCatalogObjectCallback((CatalogObject)this.serviceObject);
            if (callbackService != null) {
                this.allOperations.addAll(this.getOperations(callbackService));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private List<CustomizableOperation> getOperations(@NotNull CatalogObject catalogObject) {
        if (catalogObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/controller/AdapterExtensionProvider.getOperations must not be null");
        }
        ArrayList<CustomizableOperation> serviceOperations = new ArrayList<CustomizableOperation>();
        for (CatalogMember method : catalogObject.getMethods()) {
            CustomizableOperation operation = CustomizableOperation.createOperation(method, method.getName(), "");
            serviceOperations.add(operation);
        }
        ArrayList<CustomizableOperation> arrayList = serviceOperations;
        if (arrayList == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/fusion/soa/controller/AdapterExtensionProvider.getOperations must not return null");
        }
        return arrayList;
    }
}

