/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.action.provider;

import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bpm.adapter.Adaptable;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.msg.UIMsg;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.bpel.v1.designer.resources.images.ImageCache;
import oracle.tip.tools.ide.common.utils.ImageLoader;
import oracle.tip.tools.ide.events.projectwizard.WizardLauncher;
import oracle.tip.tools.ide.fabric.api.EndpointInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.fabric.api.SCAEndpoint;
import oracle.tip.tools.ide.fabric.config.AdapterType;
import oracle.tip.tools.ide.fabric.config.SCAConfig;
import oracle.tip.tools.ide.fabric.resource.SCAComponentRegistry;
import oracle.tip.tools.ide.fabric.resource.SCAResourceLookup;

@ActionGroupMetadata(target=CatalogModule.class)
public class CatalogModuleActions
implements ActionGroupFactory {
    public ActionGroup create(Adaptable context) {
        ActionGroup result = new ActionGroup();
        CatalogModule module = context.as(CatalogModule.class);
        String name = module.getName();
        if ("References".equals(name) || "Services".equals(name)) {
            ActionGroup group = new ActionGroup(UIMsg.NEW);
            oracle.bpm.project.model.Project project = module.getProject();
            Context ideContext = Context.newIdeContext();
            Project jdevProject = CatalogModuleActions.getJdevProject(project);
            ideContext.setProject(jdevProject);
            SCAConfig scaConfig = SCAConfig.getSCAConfig((Context)ideContext);
            List adapterTypes = scaConfig.getAdapterTypes();
            for (AdapterType adapterType : adapterTypes) {
                Icon icon = ImageCache.getIcon((String)adapterType.getIcon16x16());
                Image image = Image.create((Icon)icon);
                AdapterAction action = new AdapterAction(adapterType.getName(), image);
                group.add((BaseAction)action);
            }
            result.add((BaseAction)group);
        } else if ("Events".equals(name)) {
            ActionGroup group = new ActionGroup(UIMsg.NEW);
            group.add((BaseAction)new EventAction());
            result.add((BaseAction)group);
        }
        return result;
    }

    private static Project getJdevProject(oracle.bpm.project.model.Project project) {
        return Platform.getAdapterService().adaptTo(project, Project.class);
    }

    private static class EventAction
    extends BaseAction {
        public EventAction() {
            super(DesignerMsg.EVENT);
            this.requires(CatalogModule.class);
            ImageIcon icon = ImageLoader.getImageIcon((String)"EVENT_IMAGE_ICON");
            this.setSmallIcon(Image.create((Icon)icon));
        }

        public void run() {
            WizardLauncher wl = new WizardLauncher();
            Context ideContext = Context.newIdeContext();
            oracle.bpm.project.model.Project project = this.getCatalogModule().getProject();
            Project jdevProject = CatalogModuleActions.getJdevProject(project);
            ideContext.setProject(jdevProject);
            wl.invoke(ideContext);
        }

        private CatalogModule getCatalogModule() {
            return (CatalogModule)this.getSelection().as(CatalogModule.class);
        }
    }

    private static class AdapterAction
    extends BaseAction {
        private String adapterName;

        public AdapterAction(String adapterName, Image image) {
            super(Msg.QUOTE(adapterName));
            this.requires(CatalogModule.class);
            this.adapterName = adapterName;
            this.setSmallIcon(image);
        }

        public void run() {
            try {
                SCAEndpoint scaAdapter = SCAComponentRegistry.getInstance().getSCAAdapterInstance(this.adapterName, null);
                if (scaAdapter == null) {
                    throw new Exception(SCAResourceLookup.getString((String)"UI_ADPT_SVC_EDIT_ERR", (Object[])new String[]{this.adapterName}));
                }
                oracle.bpm.project.model.Project project = this.getCatalogModule().getProject();
                Project jdevProject = CatalogModuleActions.getJdevProject(project);
                if (jdevProject == null) {
                    throw new Exception("ERROR: Impossible create Soa Adapter '" + this.adapterName + "' because there is not JDev Project for BPM Project '" + project.getId() + "'");
                }
                SCAController scaController = SCAControllerImpl.getController((Project)jdevProject);
                EndpointInfo info = scaAdapter.createImplementation(jdevProject, scaController, false);
            }
            catch (Exception e) {
                MessageDialog.showError((Throwable)e);
            }
        }

        private CatalogModule getCatalogModule() {
            return (CatalogModule)this.getSelection().as(CatalogModule.class);
        }
    }
}

