/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa.action;

import java.net.URL;
import javax.swing.Icon;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.BusinessRuleService;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.catalog.BusinessRule;
import oracle.bpm.project.model.processes.BusinessRuleTask;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.ide.editor.EditorManager;
import oracle.tip.tools.ide.rules.resources.ImageCache;

public class OpenBusinessRuleEditorAction
extends BaseAction {
    private static OpenBusinessRuleEditorAction instance;

    private OpenBusinessRuleEditorAction() {
        super(FusionSoaMsg.OPEN_BUSINESS_RULE);
        this.requires(BusinessRuleTask.class);
        Icon icon = ImageCache.getIcon((String)"rule_navigate_node");
        this.setSmallIcon(Image.create((Icon)icon));
    }

    public static OpenBusinessRuleEditorAction getInstance() {
        if (instance == null) {
            instance = new OpenBusinessRuleEditorAction();
        }
        return instance;
    }

    public void run() {
        BusinessRule businessRule = this.getBusinessRule();
        final URL url = OpenBusinessRuleEditorAction.adaptTo(businessRule, URL.class);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                EditorManager.getEditorManager().openDefaultEditorInFrame(url);
            }
        };
        UiUtilities.invokeLater((Runnable)r);
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.getBusinessRule() != null && this.getBusinessRuleService() != null;
    }

    protected static <T> T adaptTo(Object object, Class<T> cl) {
        return Platform.getAdapterService().adaptTo(object, cl);
    }

    protected BusinessRule getBusinessRule() {
        return this.getBusinessRuleTask().getBusinessRule();
    }

    protected BusinessRuleService getBusinessRuleService() {
        StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
        return workbench.getBusinessRuleService();
    }

    private BusinessRuleTask getBusinessRuleTask() {
        return (BusinessRuleTask)this.getSelection().as(BusinessRuleTask.class);
    }
}

