/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa;

import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.action.DeleteActionFactory;
import oracle.bpm.designer.action.DeleteObjectAction;
import oracle.bpm.designer.action.NewModelAction;
import oracle.bpm.fusion.repository.JdevRepositoryService;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.lang.Platform;
import oracle.bpm.log.Log;
import oracle.bpm.project.catalog.composite.ScaControllerContext;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.MessageDialog;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.fabric.api.SCAComponentAbstract;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;

public class SCAComponentBPMN
extends SCAComponentAbstract {
    private boolean deleted;
    private oracle.bpm.project.model.Project fuegoProject;
    private ProjectObject process;
    private String processName;
    private static final int ERROR_LIMIT = 3;

    public String createImplementation(Project project, SCAController scaController, boolean b) {
        oracle.bpm.project.model.Project fuegoProject = JdevRepositoryService.getInstance().getProject(project);
        assert (fuegoProject != null);
        NewModelAction action = new NewModelAction();
        action.setOpen(false);
        action.runWithSelection((Object)fuegoProject.getModelsRoot());
        Process process = action.getProcess();
        if (process != null) {
            this.processName = process.getId();
            this.setDefintionInfo(project, scaController, this.processName);
            this.saveProcess();
        }
        return this.processName;
    }

    public void displayComponentEditor() {
        URL url = Platform.getAdapterService().adaptTo(this.getProcess(), URL.class);
        EditorManager.getEditorManager().openDefaultEditorInFrame(url);
    }

    public void displayComponentTestEditor(URL url, URL url1, String s) {
    }

    public String referenceAdded(WsdlInfo wsdlInfo, String s) {
        return null;
    }

    public void referenceRemoved(String s) {
    }

    public String serviceAdded(WsdlInfo wsdlInfo, String s) {
        return null;
    }

    public void serviceRemoved(String s) {
    }

    public void delete() {
        if (!this.deleted) {
            ProjectObject projectObject = this.getProcess();
            if (projectObject != null) {
                ScaControllerContext context = ScaControllerContext.getInstance();
                if (context.isDeleteAction((Process)projectObject)) {
                    this.deleted = true;
                    DeleteObjectAction action = DeleteActionFactory.getDeleteActionFor((ProjectObject)projectObject);
                    action.setConfirm(false);
                    action.run();
                }
            } else {
                this.deleted = true;
            }
        }
    }

    public void refreshEditor() {
    }

    public ImageIcon getIcon() {
        return null;
    }

    public boolean canAddReferences() {
        return false;
    }

    public boolean canAddInterfaces() {
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean canAddEventSubscription() {
        return false;
    }

    public void setDefintionInfo(Project project, SCAController scaController, String s) {
        super.setDefintionInfo(project, scaController, s);
        this.fuegoProject = JdevRepositoryService.getInstance().getProject(project);
        assert (this.fuegoProject != null) : "FuegoProject is null";
        int index = s.lastIndexOf(47);
        this.processName = index != -1 ? s.substring(index + 1, s.lastIndexOf(46)) : s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runValidation() {
        String result = "";
        SCAComponentBPMN sCAComponentBPMN = this;
        synchronized (sCAComponentBPMN) {
            block8: {
                ProjectObject process = this.getProcess();
                if (process != null && process.getProject().isOpen()) {
                    int checkAll = AbstractStudioWorkbench.getInstance().isBusinessAnalyst() ? 12803 : 242687;
                    ProcessChecker checker = new ProcessChecker((Process)process, new CheckOptions(checkAll));
                    try {
                        final ArrayList<String> errorMessages = new ArrayList<String>();
                        checker.setListener(new ProjectMessageListener(){

                            public void reportError(ProjectObject object, ProjectException exception) {
                                errorMessages.add(exception.getMessage());
                            }

                            public void reportWarning(ProjectObject object, ProjectException exception) {
                            }
                        });
                        checker.check();
                        if (!errorMessages.isEmpty()) {
                            int errorCount = errorMessages.size();
                            if (errorCount > 4) {
                                errorMessages.subList(3, errorCount).clear();
                                int remaining = errorCount - 3;
                                errorMessages.add(FusionSoaMsg.MORE_MESSAGES(remaining).getString());
                            }
                            result = CollectionUtils.toSeparatedString(errorMessages, "</td></tr>\n<tr><td>&nbsp;&nbsp;- ");
                        }
                    }
                    catch (ProjectException e) {
                        if (!Log.isDebugging()) break block8;
                        Log.logDebug(e);
                    }
                }
            }
            return result;
        }
    }

    private ProjectObject getProcess() {
        if (this.fuegoProject == null) {
            return null;
        }
        if (this.process == null || !this.fuegoProject.isOpen()) {
            this.process = this.getProject().findProcess(this.processName);
        }
        return this.process;
    }

    private oracle.bpm.project.model.Project getProject() {
        if (!this.fuegoProject.isOpen()) {
            this.fuegoProject = RepositoryService.getInstance().getActiveRepository().getProject(this.fuegoProject.getName());
        }
        return this.fuegoProject;
    }

    private void saveProcess() {
        if (RepositoryService.getInstance().getActiveRepository().isOpen(this.getProcess().getProject())) {
            ProjectWriter projectWriter = this.getProcess().getProject().getWriter();
            try {
                projectWriter.write(new ProjectObject[]{this.getProcess()});
            }
            catch (ProjectException e) {
                MessageDialog.showError((Throwable)e);
            }
        }
    }
}

