/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.soa;

import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import oracle.bpm.bpa.merge.BPMNSync;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.diff.VisualProcessDiffer;
import oracle.bpm.fusion.core.ProcessNode;
import oracle.bpm.fusion.soa.msg.FusionSoaMsg;
import oracle.bpm.project.ProcessContent;
import oracle.bpm.project.ProjectResourceObjectFactory;
import oracle.bpm.project.differ.AddedProjectObjectChange;
import oracle.bpm.project.differ.DefaultDescriptionFlowNodeChange;
import oracle.bpm.project.differ.DefaultLabelFlowNodeChange;
import oracle.bpm.project.differ.LaneFlowNodeChange;
import oracle.bpm.project.differ.ProjectObjectChange;
import oracle.bpm.project.differ.ProjectObjectChangeSet;
import oracle.bpm.project.differ.RemovedProjectObjectChange;
import oracle.bpm.project.differ.SequenceFlowConditionChange;
import oracle.bpm.project.io.FileSystemTokens;
import oracle.bpm.project.io.serializers.model.DefaultModelFormat;
import oracle.bpm.project.io.serializers.model.documentation.DocumentationFileGenerator;
import oracle.bpm.project.io.serializers.model.documentation.DocumentationFileLoader;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ResourceContainer;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.bpel.v1.plugins.plugins.bpa.bpaserver.connections.BPAServer;
import oracle.tip.tools.ide.bpel.v1.plugins.plugins.bpa.bpaserver.connections.BPAServerInfo;
import oracle.tip.tools.ide.bpel.v1.plugins.plugins.bpa.bpaserver.connections.BPAServerManager;
import oracle.tip.tools.ide.bpel.v1.plugins.plugins.bpa.plugin.BpaSettingsFilePlugin;
import oracle.tip.tools.ide.bpel.v1.plugins.plugins.bpa.util.BpaServerDownloadUtil;
import oracle.tip.tools.ide.common.bpel.shared.util.Helper;
import oracle.tip.tools.ide.common.bpel.shared.util.XMLHelper;
import oracle.tip.tools.ide.common.ui.statusglasspane.StatusGlassPane;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

public class RefreshBpaAction
extends BaseAction {
    public RefreshBpaAction() {
        super(FusionSoaMsg.MERGE_FROM_BPA);
        this.requires(Process.class);
    }

    public void run() {
        final StatusGlassPane glass = new StatusGlassPane((Component)Ide.getMainWindow().getContentPane());
        final Process local = this.getProcess();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List servers = BPAServerManager.getInstance().getServers();
                    BPAServerInfo info = RefreshBpaAction.this.loadBPAInfoFromProject(local);
                    BPAServer server = null;
                    for (BPAServer bpaServer : servers) {
                        if (!bpaServer.getName().equals(info.getName())) continue;
                        server = bpaServer;
                        break;
                    }
                    if (server != null) {
                        server.setBpm(true);
                        glass.setStatusDetailMessage(FusionSoaMsg.DOWNLOADING_FROM_BPA.getString());
                        File directory = RefreshBpaAction.this.getTmpProjectDirectory(server, info);
                        Project project = local.getProject();
                        Process remote = ProjectResourceObjectFactory.createProcess((ResourceContainer)project, (String)(local.getId() + "_from_bpa"), (boolean)true);
                        File file = RefreshBpaAction.this.getBpmnFile(local.getId(), directory);
                        if (file != null) {
                            DefaultModelFormat.load((Process)remote, (File)file);
                            if (!ModelUtils.isDefaultProcess((Process)remote)) {
                                File docFile = new File(directory.getAbsolutePath() + "/" + DocumentationFileGenerator.generateDocumentationFileName((Process)remote));
                                DocumentationFileLoader.loadDocumentationFromTemp((File)docFile, (Process)remote);
                            }
                            BPMNSync sync = new BPMNSync(local, remote, (Process)local.copy());
                            Process mergedProc = sync.merge(false);
                            ProjectObjectChangeSet changes = RefreshBpaAction.this.createProjectObjectChangesFromSync(sync);
                            if (!changes.isEmpty()) {
                                glass.enableUserInput(true);
                                mergedProc = sync.merge(true);
                                boolean merge = VisualProcessDiffer.merge((Process)local, (Process)remote, (Process)mergedProc, (ProjectObjectChangeSet)changes, (String)"bpa_merge");
                                if (merge) {
                                    RefreshBpaAction.this.closeEditor(local);
                                    List adapters = ((ProcessContent)local).getAdapters();
                                    for (Object adapter : adapters) {
                                        if (adapter instanceof ProcessNode) continue;
                                        ((ProcessContent)mergedProc).addAdapter(adapter);
                                    }
                                    ProjectObjectContainer parentObject = (ProjectObjectContainer)local.getParentObject();
                                    mergedProc.setParentObject((ProjectObject)parentObject);
                                    local.replace((ProjectObject)mergedProc);
                                    mergedProc.setDirty(true);
                                    RefreshBpaAction.this.openEditor(mergedProc);
                                }
                            } else {
                                MessageDialog.showWarning((Msg)FusionSoaMsg.NO_DIFF_FOUND);
                            }
                        }
                    } else {
                        MessageDialog.showError((Msg)FusionSoaMsg.SERVER_NOT_FOUND(info.getName()));
                    }
                }
                catch (Exception e) {
                    MessageDialog.showError((Throwable)e);
                }
                finally {
                    glass.enableUserInput(true);
                }
            }
        };
        glass.setStatusMessage(FusionSoaMsg.MERGE_FROM_BPA.getString(), FusionSoaMsg.FIND_SERVER_TO_SYNC.getString());
        glass.enableUserInput(false);
        new Thread(runnable).start();
    }

    public boolean isEnabled() {
        try {
            Process process = this.getProcess();
            return this.loadBPAInfoFromProject(process) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void closeEditor(final @NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/RefreshBpaAction.closeEditor must not be null");
        }
        UiUtilities.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
                StudioEditor processEditor = workbench.findEditorByObject((Object)process);
                if (processEditor != null) {
                    workbench.closeEditorAfterDelete(processEditor);
                }
            }
        });
    }

    private void openEditor(final @NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/RefreshBpaAction.openEditor must not be null");
        }
        final StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
        UiUtilities.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                workbench.openEditorForObject((Object)process);
            }
        });
    }

    private File getBpmnFile(String processId, File directory) throws MalformedURLException {
        try {
            URL processes = URLFactory.newDirURL((URL)directory.toURI().toURL(), (String)"processes");
            URL process = URLFactory.newURL((URL)processes, (String)(processId + ".bpmn"));
            return new File(process.getFile());
        }
        catch (NullPointerException e) {
            MessageDialog.showError((Msg)FusionSoaMsg.CANNOT_FETCH_FROM_BPA_REPO);
            return null;
        }
    }

    private BPAServerInfo loadBPAInfoFromProject(Process process) throws Exception {
        BPAServerInfo info;
        File root = process.getProject().getWriter().getProjectFileSystem().getLocalFileSystem().getRootFolder();
        URL designer = URLFactory.newDirURL((URL)root.toURI().toURL(), (String)".designer");
        URL fileURL = URLFactory.newURL((URL)designer, (String)"bpaserver_download_info.xml");
        if (URLFileSystem.exists((URL)fileURL)) {
            Document doc = XMLHelper.loadDocument((URL)fileURL);
            info = BpaSettingsFilePlugin.readBPAServerInfo((Document)doc);
        } else {
            info = null;
        }
        return info;
    }

    private File getTmpProjectDirectory(BPAServer server, BPAServerInfo info) {
        File extracted;
        try {
            File tmp = FileSystemTokens.getTempProjectsDir();
            File zip = BpaServerDownloadUtil.downloadZip((BPAServer)server, (String)info.getOGuid(), (boolean)true);
            extracted = new File(tmp, "TmpProjectBPA" + System.nanoTime());
            if (extracted.exists()) {
                Helper.deleteDirectory((String)extracted.getAbsolutePath());
            }
            BpaServerDownloadUtil.extractZipFile((File)zip, (File)extracted);
        }
        catch (Exception e) {
            extracted = null;
        }
        return extracted;
    }

    private ProjectObjectChangeSet createProjectObjectChangesFromSync(@NotNull BPMNSync sync) {
        if (sync == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/soa/RefreshBpaAction.createProjectObjectChangesFromSync must not be null");
        }
        ProjectObjectChangeSet changes = new ProjectObjectChangeSet((ProjectObject)sync.getAnalystBpmn());
        HashMap nodesRemotelyAdded = sync.getNodesAddedFromServer();
        for (FlowNode node : nodesRemotelyAdded.values()) {
            changes.append((ProjectObjectChange)new AddedProjectObjectChange((ProjectObject)node));
        }
        HashMap nodesLocallyAdded = sync.getNodesAddedInStudio();
        for (FlowNode node : nodesLocallyAdded.values()) {
            changes.append((ProjectObjectChange)new RemovedProjectObjectChange((ProjectObject)node));
        }
        HashMap flowsRemotelyAdded = sync.getFlowsAddedFromServer();
        for (SequenceFlow flow : flowsRemotelyAdded.values()) {
            changes.append((ProjectObjectChange)new AddedProjectObjectChange((ProjectObject)flow));
        }
        HashMap flowsRemotelyModified = sync.getFlowsModifiedInServer();
        for (SequenceFlow flow : flowsRemotelyModified.values()) {
            changes.append((ProjectObjectChange)new SequenceFlowConditionChange(flow, flow.asConditionalFlow().getCondition().getExpressionValue()));
        }
        HashMap nodesLabelRemotelyChanged = sync.getNodesLabelChangedFromServer();
        for (FlowNode node : nodesLabelRemotelyChanged.values()) {
            changes.append((ProjectObjectChange)new DefaultLabelFlowNodeChange(node, node.getDefaultLabel()));
        }
        HashMap nodesDescRemotelyChanged = sync.getNodesDescChangedFromServer();
        for (FlowNode node : nodesDescRemotelyChanged.values()) {
            changes.append((ProjectObjectChange)new DefaultDescriptionFlowNodeChange(node, node.getDefaultDescription()));
        }
        HashMap nodesLaneRemotelyChanged = sync.getNodesLaneChangedFromServer();
        for (FlowNode node : nodesLaneRemotelyChanged.values()) {
            changes.append((ProjectObjectChange)new LaneFlowNodeChange(node, node.getLane()));
        }
        return changes;
    }

    private Process getProcess() {
        return (Process)this.getSelection().as(Process.class);
    }
}

