/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.renderer;

import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.renderer.AbstractRenderer;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawableLaneName;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import org.jetbrains.annotations.NotNull;

public class LaneBackgroundRenderer
extends AbstractRenderer {
    private static final int GRID_SIZE = 10;

    private LaneBackgroundRenderer(@NotNull DrawableLaneName drawable) {
        super(drawable);
    }

    public static Renderer create(@NotNull DrawableLaneName drawable) {
        return new LaneBackgroundRenderer(drawable);
    }

    @Override
    public void render() {
        DiagramContext context = this.getContext();
        Point origin = this.getDrawable().getBounds().getOrigin();
        Graphics graphics = context.getGraphics();
        Color original = graphics.getForeground();
        Rectangle bounds = context.scale(Rectangle.valueOf((int)origin.getX(), (int)(origin.getY() + 1), (int)20000, (int)this.getDrawable().getHeight()));
        this.renderBack(graphics, bounds);
        if (context.isShowGrid()) {
            this.renderGrid(context, graphics, bounds);
        }
        graphics.setForeground(original);
    }

    @Override
    protected DrawableLaneName getDrawable() {
        return (DrawableLaneName)super.getDrawable();
    }

    private void renderGrid(DiagramContext context, Graphics graphics, Rectangle bounds) {
        Color dark = Color.FUEGO_LIGHT_BLUE;
        Color light = Color.valueOf((Color)Color.FUEGO_LIGHT_BLUE, (int)160);
        int x = bounds.getX();
        int y = bounds.getY();
        int w = bounds.getWidth();
        int h = bounds.getHeight();
        int step = context.scale(10);
        boolean skip = step < 5;
        for (int i = x / step; i <= (x + w) / step + 1; ++i) {
            if (i % 8 == 0) {
                graphics.setForeground(dark);
            } else {
                if (skip) continue;
                graphics.setForeground(light);
            }
            int xStep = i * step;
            graphics.drawLine(xStep, y, xStep, y + h);
        }
        for (int j = y / step; j <= (y + h) / step + 1; ++j) {
            if (j % 8 == 0) {
                graphics.setForeground(dark);
            } else {
                if (skip) continue;
                graphics.setForeground(light);
            }
            int yStep = j * step;
            graphics.drawLine(x, yStep, x + w, yStep);
        }
    }

    private void renderBack(Graphics graphics, Rectangle bounds) {
        graphics.setForeground(Color.WHITE);
        graphics.fill(bounds);
        graphics.setForeground(this.getDrawable().getColumn().getBackground());
        graphics.fill(bounds);
    }
}

