/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.renderer;

import java.awt.Polygon;
import java.net.MalformedURLException;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.draw.renderer.FlowElementRenderer;
import oracle.bpm.draw.renderer.GraphicsMemento;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.features.IsDraftFeature;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.ui.CustomImageHelper;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.ScaledPolygon;
import oracle.bpm.ui.Ui;
import org.jetbrains.annotations.NotNull;

public class FlowElementImageRenderer
extends FlowElementRenderer {
    protected FlowElementImageRenderer(@NotNull DrawableFlowElement drawable) {
        super(drawable);
    }

    public static FlowElementImageRenderer create(@NotNull DrawableFlowElement drawable) {
        return new FlowElementImageRenderer(drawable);
    }

    public static Image getImage(@NotNull DrawableFlowElement<?> drawable, @NotNull DrawContext context) {
        Object flowElement = drawable.getModelObject();
        return drawable.isShowSelection() || context.isHighlighted(drawable) ? FlowElementImageRenderer.getSelectedImage(flowElement, context) : FlowElementImageRenderer.getNormalImage(flowElement, context);
    }

    public static Image getNormalImage(@NotNull FlowElement flowElement, @NotNull DrawContext context) {
        Image result = FlowElementImageRenderer.getCustomImage(flowElement, ImageType.NORMAL);
        if (result == null) {
            result = context.getTheme().getImageFor(flowElement);
        }
        return result;
    }

    @Override
    public void render() {
        IsDraftFeature feature;
        DrawContext context = this.getContext();
        Graphics g = context.getGraphics();
        Image imageToShow = this.getImage();
        Rectangle bounds = this.getScaledDrawableBounds();
        GraphicsMemento memento = GraphicsMemento.create(g);
        if (this.getDrawable().isShowSelection() || this.getContext().isHighlighted(this.getDrawable())) {
            float scale;
            float poligonScale = scale = 1.2f;
            Rectangle scaledBounds = this.getScaledDrawableBounds();
            Point newOrigin = scaledBounds.getOrigin();
            Dimension originalSize = scaledBounds.getSize();
            if (Ui.supportsSVG()) {
                float scaleFactor = this.getScaleFactorForModelObject();
                originalSize = scaleFactor == 1.0f ? originalSize : originalSize.scaled(scaleFactor);
                poligonScale = scale * scaleFactor;
            }
            Dimension newSize = originalSize.scaled(scale);
            int deltaX = newSize.getWidth() - originalSize.getWidth();
            int deltaY = newSize.getHeight() - originalSize.getHeight();
            newOrigin = new Point(newOrigin.getX() - deltaX / 2, newOrigin.getY() - deltaY / 2);
            scaledBounds = new Rectangle(newOrigin, newSize);
            Color originalForeground = g.getForeground();
            g.translate(scaledBounds.getX(), scaledBounds.getY());
            g.setForeground(Color.valueOf((Color)Color.FUEGO_LIGHT_BLUE, (int)150));
            oracle.bpm.geom.Polygon polygon = this.getScaledDrawPolygon(context.getScale() * poligonScale);
            g.fillPolygon(new Polygon(polygon.xpoints, polygon.ypoints, polygon.npoints));
            g.setForeground(Color.valueOf((Color)Color.FUEGO_LIGHT_BLUE, (int)200));
            g.translate(-scaledBounds.getX(), -scaledBounds.getY());
            g.setForeground(originalForeground);
        }
        if (context.isDiffElement(this.getDrawable())) {
            Color original = g.getForeground();
            g.setForeground(Color.valueOf((Color)context.getDiffColor(), (int)200));
            Rectangle diff = bounds.expand(30);
            g.fillRoundRect(diff.getX(), diff.getY(), diff.getWidth(), diff.getHeight(), 10, 10);
            g.setForeground(original);
        }
        if ((feature = (IsDraftFeature)this.getModelObject().getFeature(IsDraftFeature.class)) != null && feature.getValue().booleanValue()) {
            g.setUseFilter(true);
        }
        g.drawImage(imageToShow, bounds);
        g.setUseFilter(false);
        if (context.isHighlighted(this.getDrawable())) {
            Color c = g.getForeground();
            Stroke s = g.getStroke();
            g.setForeground(Color.DARK_GREEN);
            g.setStroke(Stroke.FOUR_SOLID);
            g.translate(bounds.getX(), bounds.getY());
            g.draw(this.getScaledDrawPolygon());
            g.setForeground(Color.BLACK);
            g.setStroke(Stroke.ONE_SOLID);
            g.draw(this.getScaledDrawPolygon());
            g.translate(-bounds.getX(), -bounds.getY());
            g.setForeground(c);
            g.setStroke(s);
        }
        memento.restore(g);
    }

    @Override
    public boolean contains(int x, int y) {
        Point top = this.getDrawable().getBounds().getTop();
        Image image = this.getImage();
        Point check = top.translate(-x, -y);
        Rectangle bounds = this.getDrawable().getBounds();
        return image.isVisible(check.getX(), check.getY(), bounds) || image.isInside(check, bounds);
    }

    @Override
    public Rectangle getRenderBounds() {
        Rectangle result;
        if (this.useDefaultImageDimension()) {
            Image image = this.getImage();
            result = Rectangle.createAround((Point)this.getDrawable().getLocation(), (int)image.getWidth(), (int)image.getHeight());
        } else {
            result = this.getDrawable().getBounds();
        }
        return result;
    }

    @Override
    public Dimension getRenderDimension() {
        Dimension result;
        if (this.useDefaultImageDimension()) {
            Image image = this.getImage();
            result = Dimension.valueOf((int)image.getWidth(), (int)image.getHeight());
        } else {
            result = Dimension.valueOf((int)this.getDrawable().getWidth(), (int)this.getDrawable().getHeight());
        }
        return result;
    }

    protected static Image getSelectedImage(@NotNull FlowElement flowElement, @NotNull DrawContext context) {
        Image result = FlowElementImageRenderer.getCustomImage(flowElement, ImageType.SELECTED);
        if (result == null) {
            result = context.getTheme().getImageFor(flowElement, ImageType.SELECTED);
        }
        return result;
    }

    protected static Image getCustomImage(FlowElement flowElement, ImageType selected) {
        try {
            return CustomImageHelper.getCustomImage((FlowElement)flowElement);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Image getNormalImage() {
        return FlowElementImageRenderer.getNormalImage(this.getDrawable().getModelObject(), this.getContext());
    }

    protected Image getSelectedImage() {
        return FlowElementImageRenderer.getSelectedImage(this.getDrawable().getModelObject(), this.getContext());
    }

    @NotNull
    protected FlowElement getModelObject() {
        return this.getDrawable().getModelObject();
    }

    float getScaleFactorForModelObject() {
        FlowFigureType flow;
        BpmnType type = FlowFigureUtils.fromElement(this.getDrawable().getModelObject()).getType();
        if (type == BpmnType.BOUNDARY_EVENT) {
            return 0.75f;
        }
        if ((type == BpmnType.END_EVENT || type == BpmnType.START_EVENT) && this.getDrawable().getContainer().getLayer() == DesignerLayer.SUBPROCESS && (flow = FlowFigureUtils.fromElement((FlowElement)this.getDrawable().getContainer().getModelObject())) == FlowFigureType.SUBPROCESS) {
            return 0.4f;
        }
        return 1.0f;
    }

    private boolean useDefaultImageDimension() {
        return !Ui.supportsSVGResize() || this.getDrawable().getWidth() == 0 || this.getDrawable().getHeight() == 0;
    }

    private Image getImage() {
        Object flowElement = this.getDrawable().getModelObject();
        Image result = FlowElementImageRenderer.getNormalImage(flowElement, this.getContext());
        if (Ui.supportsSVG()) {
            float scale = this.getScaleFactorForModelObject();
            result = scale == 1.0f ? result : result.getScaledInstance((double)scale);
        }
        return result;
    }

    private oracle.bpm.geom.Polygon getScaledDrawPolygon() {
        DrawContext context = this.getContext();
        float scale = context.getScale();
        if (Ui.supportsSVG()) {
            scale *= this.getScaleFactorForModelObject();
        }
        return this.getScaledDrawPolygon(scale);
    }

    private oracle.bpm.geom.Polygon getScaledDrawPolygon(float scale) {
        ScaledPolygon polygon = this.getCustomImagePolygon();
        if (polygon == null) {
            DrawContext context = this.getContext();
            FlowFigureType type = FlowFigureUtils.fromElement(this.getModelObject());
            polygon = context.getTheme().getPolygon(type);
        }
        return polygon.getScaledPolygon(scale);
    }

    private ScaledPolygon getCustomImagePolygon() {
        try {
            Image customImage = CustomImageHelper.getCustomImage((FlowElement)this.getModelObject());
            if (customImage != null) {
                oracle.bpm.geom.Polygon pol = customImage.surroundingPolygon();
                return new ScaledPolygon(pol);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Rectangle getScaledDrawableBounds() {
        return this.getContext().scale(this.getDrawable().getBounds());
    }
}

