/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.renderer;

import java.io.IOException;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.Utilities;
import oracle.bpm.draw.renderer.FlowElementRenderer;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.activities.CustomImageFeature;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class FlowElementCustomImageRenderer
extends FlowElementRenderer {
    private Image localImage;
    private Image selectedLocalImage;

    private FlowElementCustomImageRenderer(@NotNull DrawableFlowElement drawable) {
        super(drawable);
    }

    public static FlowElementCustomImageRenderer create(@NotNull DrawableFlowElement drawable) {
        return new FlowElementCustomImageRenderer(drawable);
    }

    @Override
    public void render() {
        Rectangle bounds = this.getScaledDrawableBounds();
        this.getContext().getGraphics().drawImage(this.getImage(), bounds);
    }

    @Override
    public boolean contains(int x, int y) {
        DrawableFlowElement drawable = this.getDrawable();
        Point location = drawable.getBounds().getOrigin();
        Point position = new Point(x, y);
        return this.getImage().isInside(position.sub(location), this.getDrawable().getBounds());
    }

    @Override
    public Rectangle getRenderBounds() {
        return this.getDrawable().getBounds();
    }

    @Override
    public Dimension getRenderDimension() {
        return Dimension.valueOf((int)this.getDrawable().getWidth(), (int)this.getDrawable().getHeight());
    }

    private Image getImage() {
        DrawableFlowElement drawable = this.getDrawable();
        return drawable.isShowSelection() || this.getContext().isHighlighted(drawable) ? this.getSelectedImage() : this.getNormalImage();
    }

    private Image getNormalImage() {
        Image result = this.getContext().getTheme().getImageFor(this.getModelObject());
        if (this.getFeature(CustomImageFeature.class).getUseLocalImageFeature().getValue().booleanValue()) {
            Image local = this.getLocalImage();
            result = local == null ? result : local;
        }
        return result;
    }

    private Image getLocalImage() {
        if (this.localImage == null) {
            try {
                this.localImage = Image.createFromBase64((String)this.getFeature(CustomImageFeature.class).getEncodedLocalImage());
            }
            catch (IOException e) {
                Log.logWarning((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                Log.logWarning((Throwable)e);
            }
        }
        return this.localImage;
    }

    private Image getSelectedImage() {
        Image result = this.getContext().getTheme().getImageFor(this.getModelObject(), ImageType.SELECTED);
        if (this.getFeature(CustomImageFeature.class).getUseLocalImageFeature().getValue().booleanValue()) {
            Image local = this.getSelectedLocalImage();
            result = local == null ? result : local;
        }
        return result;
    }

    private Image getSelectedLocalImage() {
        if (this.selectedLocalImage == null) {
            Image image = this.getLocalImage();
            this.selectedLocalImage = this.getFeature(CustomImageFeature.class).getInvertPaletteFeature().getValue() != false ? Utilities.invertImage(image) : image;
        }
        return this.selectedLocalImage;
    }

    private Rectangle getScaledDrawableBounds() {
        return this.getContext().scale(this.getDrawable().getBounds());
    }

    private <T extends Feature> T getFeature(Class<T> featureClass) {
        return (T)this.getModelObject().getFeature(featureClass);
    }

    @NotNull
    private FlowElement getModelObject() {
        return this.getDrawable().getModelObject();
    }
}

