/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.diagram;

import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Locale;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Function;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.diagram.draw.DrawableUtils;
import oracle.bpm.draw.BpmnDrawableFactory;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableChildPopulator;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableHelper;
import oracle.bpm.draw.DrawableSingleProcessRoot;
import oracle.bpm.draw.diagram.DiagramEvent;
import oracle.bpm.draw.diagram.ProcessDiagrammer;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.features.IsCollapsedFeature;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.ui.CustomImageHelper;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.utils.ImageIOFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageProcessDiagrammer
implements ProcessDiagrammer {
    private DrawContext context;
    private DrawableSingleProcessRoot root;

    public ImageProcessDiagrammer(@NotNull Process process) {
        this(process, true);
    }

    public ImageProcessDiagrammer(@NotNull Process process, boolean expandSubprocesses) {
        this.context = new DrawContext(process.getProject().getPreferences().getDefaultLanguage());
        this.context.setContainer((UiContainer)new Panel(null));
        this.root = DrawableSingleProcessRoot.create(null, this.context);
        if (expandSubprocesses) {
            this.expandSubprocesses(process);
        }
        this.addProcessToRoot(process);
        Rectangle bounds = this.root.getSingleProcess().getBounds().expand(24);
        this.context.setRectangle(Rectangle.valueOf((Point)Point.ORIGIN, (int)bounds.getWidth(), (int)bounds.getHeight()));
        this.updateContext();
    }

    public void rebuild() {
        Process process = this.getProcess();
        this.root = DrawableSingleProcessRoot.create(null, this.context);
        this.addProcessToRoot(process);
    }

    @Override
    public void highlight(@NotNull Iterable<DiagramEvent> events) {
        this.context.clearHighlightedActivities();
        this.context.clearHighlightedTransitions();
        for (DiagramEvent event : events) {
            switch (event.getType()) {
                case FLOW_NODE_IN: {
                    if (event.isCancelled()) break;
                    this.highlightFlowNode(event);
                    break;
                }
                case SEQUENCE_FLOW: {
                    this.highlightSequenceFlow(event);
                }
            }
        }
    }

    @Override
    @NotNull
    public String getImage() {
        Image image = DrawableUtils.createImageForDrawable(this.root, this.context, this.context.getRectangle());
        return ImageIOFacade.encodeBase64Image((Image)image);
    }

    @Override
    @NotNull
    public Rectangle getBoundsForFlowElement(@NotNull String flowElementId) {
        FlowElement flowElement = this.findFlowElement(flowElementId);
        return this.getDrawable(flowElement).getBounds();
    }

    @Override
    @NotNull
    public String getImageForFlowElement(@NotNull String flowElementId) {
        FlowElement flowElement = this.findFlowElement(flowElementId);
        Image image = flowElement != null ? DrawableUtils.createImageForDrawable(this.getDrawable(flowElement), this.context) : Image.create((int)1, (int)1);
        return ImageIOFacade.encodeBase64Image((Image)image);
    }

    @Override
    @NotNull
    public String getIconForFlowElement(@NotNull String flowElementId) {
        Image result;
        FlowElement flowElement = this.findFlowElement(flowElementId);
        if (flowElement != null) {
            result = this.getCustomImage(flowElement);
            if (result == null) {
                result = this.context.getTheme().getImageFor(flowElement, ImageType.ICON);
            }
        } else {
            result = Image.create((int)1, (int)1);
        }
        return ImageIOFacade.encodeBase64Image((Image)result);
    }

    @Override
    @NotNull
    public String getIconForFlowFigureType(@NotNull FlowFigureType type) {
        Image image = this.context.getTheme().getImageFor(type, ImageType.ICON);
        return ImageIOFacade.encodeBase64Image((Image)image);
    }

    @Override
    @Deprecated
    @NotNull
    public String getImageForFlowNode(@NotNull String flowNodeId) {
        return this.getImageForFlowElement(flowNodeId);
    }

    @Override
    @Deprecated
    @NotNull
    public String getIconForFlowNode(@NotNull String flowNodeId) {
        return this.getIconForFlowElement(flowNodeId);
    }

    @Override
    @Deprecated
    @NotNull
    public Rectangle getBoundsForFlowNode(@NotNull String flowNodeId) {
        return this.getBoundsForFlowElement(flowNodeId);
    }

    @Override
    public void setLocale(@NotNull Locale locale) {
        this.context.setLocale(locale);
    }

    @Override
    public void setScale(float scale) {
        this.context.setScale(scale);
    }

    @Override
    public Process getProcess() {
        return (Process)this.root.getSingleProcess().getModelObject();
    }

    @Override
    public FlowElement findFlowElement(final @NotNull String flowNodeId) {
        return this.findFlowElement((NodeContainer)this.getProcess(), new Function<NodeContainer, FlowElement>(){

            public FlowElement eval(NodeContainer container) {
                return (FlowElement)CollectionUtils.findFirst((Iterable)container.getChildrenByType(FlowElement.class), (Predicate)new Predicate<FlowElement>(){

                    public boolean check(@Nullable FlowElement value) {
                        return value != null && value.getId().equalsIgnoreCase(flowNodeId);
                    }
                });
            }
        });
    }

    protected void updateContext() {
    }

    protected DrawContext getContext() {
        return this.context;
    }

    protected DrawableSingleProcessRoot getRoot() {
        return this.root;
    }

    private Image getCustomImage(@NotNull FlowElement flowElement) {
        Image result;
        try {
            result = CustomImageHelper.getCustomImage((FlowElement)flowElement);
        }
        catch (MalformedURLException e) {
            result = null;
        }
        return result;
    }

    private void expandSubprocesses(Process process) {
        Sequence subprocessSequence = process.getDescendants(Subprocess.class);
        for (Subprocess subprocess : subprocessSequence) {
            ((IsCollapsedFeature)subprocess.getFeature(IsCollapsedFeature.class)).setValue(Boolean.valueOf(false));
        }
    }

    private void highlightSequenceFlow(@NotNull DiagramEvent event) {
        SequenceFlow flow = this.findSequenceFlow(event.getFlowElementId());
        this.context.addHighlightedTransition(flow);
    }

    private void highlightFlowNode(@NotNull DiagramEvent event) {
        this.context.addHighlightedActivity(event.getFlowElementId());
    }

    private DrawableFlowElement<?> getDrawable(@NotNull FlowElement element) {
        return DrawableHelper.findDrawableRecursively(this.root.getSingleProcess(), element);
    }

    private SequenceFlow findSequenceFlow(final @NotNull String sequenceFlowId) {
        return this.findFlowElement((NodeContainer)this.getProcess(), new Function<NodeContainer, SequenceFlow>(){

            public SequenceFlow eval(NodeContainer container) {
                return container.findSequenceFlow(sequenceFlowId);
            }
        });
    }

    private <T extends FlowElement> T findFlowElement(@NotNull NodeContainer container, @NotNull Function<NodeContainer, T> finder) {
        Object result;
        block1: {
            NodeContainer inner;
            result = (FlowElement)finder.eval((Object)container);
            if (result != null) break block1;
            Iterator i$ = container.getChildrenByType(NodeContainer.class).iterator();
            while (i$.hasNext() && (result = this.findFlowElement(inner = (NodeContainer)i$.next(), finder)) == null) {
            }
        }
        return (T)result;
    }

    private void addProcessToRoot(@NotNull Process process) {
        BpmnDrawableFactory factory = BpmnDrawableFactory.getInstance();
        DrawableChildPopulator.populateChild(factory, this.root, process);
    }
}

