/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw.diagram;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.collections.Sequence;
import oracle.bpm.diagram.draw.DrawableUtils;
import oracle.bpm.draw.diagram.ImageProcessDiagrammer;
import oracle.bpm.draw.diagram.SubprocessExpansionMode;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.features.IsCollapsedFeature;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Positional;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.utils.ImageIOFacade;
import org.jetbrains.annotations.NotNull;

public class AuditProcessDiagrammer
extends ImageProcessDiagrammer {
    private SubprocessExpansionMode mode;

    public AuditProcessDiagrammer(@NotNull Process process) {
        this(process, true);
    }

    public AuditProcessDiagrammer(@NotNull Process process, boolean mode) {
        super(process, mode);
        this.getContext().setShowNotes(false);
        if (mode) {
            this.expandSubprocesses(process);
        }
        Rectangle bounds = this.getRoot().getBounds();
        this.getContext().setRectangle(Rectangle.valueOf((Point)Point.ORIGIN, (int)bounds.getWidth(), (int)bounds.getHeight()));
        this.updateContext();
    }

    @Override
    @NotNull
    public String getImage() {
        Image image = DrawableUtils.createImageForDrawable(this.getRoot().getSingleProcess(), this.getContext());
        return ImageIOFacade.encodeBase64Image((Image)image);
    }

    public AuditImageInfo getInfoFor(String subprocessId, Process process) {
        return this.getAuditInfo(process, subprocessId);
    }

    private AuditImageInfo getAuditInfo(Process process, String subProcessID) {
        AuditImageInfo result = null;
        if (subProcessID == null) {
            Map<String, LocationInfo> subprocessMap = this.generateMap((NodeContainer)process);
            result = new AuditImageInfo(this.getImage(), subprocessMap);
        } else {
            Subprocess subProcess = (Subprocess)process.findDescendant(Subprocess.class, subProcessID);
            if (subProcess != null) {
                ArrayList<Subprocess> collapsedSubprocess = new ArrayList<Subprocess>();
                this.expandParentProcess((NodeContainer)subProcess, collapsedSubprocess);
                this.rebuild();
                String subprocessImage = this.getImageForFlowElement(subProcessID);
                Map<String, LocationInfo> subprocessMap = this.generateMap((NodeContainer)subProcess);
                this.collapseParentProcess(collapsedSubprocess);
                result = new AuditImageInfo(subprocessImage, subprocessMap);
            }
        }
        return result;
    }

    private Map<String, LocationInfo> generateMap(NodeContainer container) {
        HashMap<String, LocationInfo> subprocessMap = new HashMap<String, LocationInfo>();
        for (Subprocess child : container.getChildrenByType(Subprocess.class)) {
            LocationInfo info = new LocationInfo((Positional)child);
            subprocessMap.put(child.getId(), info);
        }
        return subprocessMap;
    }

    private void collapseParentProcess(ArrayList<Subprocess> collapsedSubprocess) {
        for (Subprocess collapsedSubproces : collapsedSubprocess) {
            ((IsCollapsedFeature)collapsedSubproces.getFeature(IsCollapsedFeature.class)).setValue(Boolean.valueOf(true));
        }
    }

    private void expandParentProcess(NodeContainer container, ArrayList<Subprocess> collapsedProcesses) {
        if (container instanceof Subprocess) {
            Subprocess subprocess = (Subprocess)container;
            this.expandParentProcess(subprocess.getParentObject(), collapsedProcesses);
            IsCollapsedFeature feature = (IsCollapsedFeature)subprocess.getFeature(IsCollapsedFeature.class);
            if (feature.getValue().booleanValue()) {
                collapsedProcesses.add(subprocess);
                feature.setValue(Boolean.valueOf(false));
            }
        }
    }

    private void expandSubprocesses(Process process) {
        Sequence subprocessSequence = process.getDescendants(Subprocess.class);
        for (Subprocess subprocess : subprocessSequence) {
            ((IsCollapsedFeature)subprocess.getFeature(IsCollapsedFeature.class)).setValue(Boolean.valueOf(false));
        }
    }

    private class LocationInfo {
        private Positional positional;

        protected LocationInfo(Positional positional) {
            this.positional = positional;
        }

        public Point getLocation() {
            return this.positional.getLocation();
        }

        public int getWidth() {
            return this.positional.getWidth();
        }

        public int getHeight() {
            return this.positional.getHeight();
        }
    }

    public class AuditImageInfo {
        private Map<String, LocationInfo> subProcessesLocation;
        private String subProcessImage;

        public AuditImageInfo(String subProcessImage, Map<String, LocationInfo> subProcessesLocation) {
            this.subProcessImage = subProcessImage;
            this.subProcessesLocation = subProcessesLocation;
        }

        public String getSubprocessImage() {
            return this.subProcessImage;
        }

        public Map<String, LocationInfo> getSubprocessesLocation() {
            return this.subProcessesLocation;
        }
    }
}

