/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.draw.DrawableActivity;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.DrawableLaneColumn;
import oracle.bpm.draw.DrawableLaneName;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.ui.ModelObjectSelection;
import oracle.bpm.ui.selection.Selection;
import org.jetbrains.annotations.NotNull;

public class ProcessSelection
implements Selection,
Iterable<DrawableFlowElement> {
    protected boolean drawRectangle;
    private DrawableNodeContainer<?> container;
    private ArrayList<DrawableFlowElement> flowElements = new ArrayList();
    private Process process;

    public ProcessSelection(@NotNull DrawableNodeContainer<?> container) {
        this.process = ((NodeContainer)container.getModelObject()).getProcess();
        this.container = container;
    }

    public ModelObjectSelection asModelObjectSelection() {
        return ModelObjectSelection.create(this.getAllModelObjects());
    }

    @NotNull
    public DrawableNodeContainer<?> getDrawableContainer() {
        return this.container;
    }

    public List<FlowNode> getAllActivities() {
        ArrayList<FlowNode> list = new ArrayList<FlowNode>();
        for (DrawableFlowElement d : this) {
            Object modelObject = d.getModelObject();
            if (!(modelObject instanceof FlowNode)) continue;
            FlowNode act = (FlowNode)modelObject;
            list.add(act);
        }
        return list;
    }

    public List<DrawableActivity> getAllDrawableActivities() {
        ArrayList<DrawableActivity> list = new ArrayList<DrawableActivity>();
        for (DrawableFlowElement d : this) {
            Object modelObject = d.getModelObject();
            if (!(modelObject instanceof FlowNode)) continue;
            list.add((DrawableActivity)d);
            FlowNode act = (FlowNode)modelObject;
            if (!ModelUtils.isSubprocess((FlowNode)act)) continue;
        }
        return list;
    }

    public List<DrawableFlowElement> getAllObjects() {
        HashSet<DrawableFlowElement> set = new HashSet<DrawableFlowElement>(this.flowElements);
        HashMap<String, Object> flowElementMap = new HashMap<String, Object>();
        ArrayList<DrawableFlowElement> list = new ArrayList<DrawableFlowElement>();
        for (DrawableFlowElement drawableFlowElement : this) {
            if (!(drawableFlowElement instanceof LaneImpl)) continue;
            for (FlowNode node : ((LaneImpl)drawableFlowElement).getActivityList()) {
                set.add((DrawableFlowElement)node);
            }
        }
        for (DrawableFlowElement<Object> drawableFlowElement : set) {
            Object modelObject = drawableFlowElement.getModelObject();
            if (flowElementMap.put(modelObject.getId(), modelObject) != null) continue;
            list.add(drawableFlowElement);
        }
        return list;
    }

    public void setDrawRectangle(boolean drawRectangle) {
        this.drawRectangle = !this.flowElements.isEmpty() && drawRectangle;
    }

    public boolean isMultiple() {
        return this.getAllObjects().size() > 1;
    }

    public boolean isSingle() {
        return this.flowElements.size() == 1;
    }

    public boolean isEmpty() {
        return this.flowElements.isEmpty();
    }

    public Object getObject(int index) {
        return this.flowElements.get(index);
    }

    public ArrayList<DrawableFlowElement> getObjects() {
        return new ArrayList<DrawableFlowElement>(this.flowElements);
    }

    public void addAllObjects(List<DrawableFlowElement> components) {
        this.flowElements.addAll(components);
    }

    public void addObject(DrawableFlowElement dObj) {
        if (!this.flowElements.contains(dObj) && dObj != this) {
            this.flowElements.add(dObj);
        }
    }

    public void clear() {
        this.flowElements.clear();
    }

    public boolean containsAllObjects(Sequence<FlowNode> components) {
        for (FlowNode o : components) {
            if (this.flowElements.contains(o)) continue;
            return false;
        }
        return true;
    }

    public boolean containsObject(DrawableFlowElement dObj) {
        return this.flowElements.contains(dObj);
    }

    public void includeAllActivities() {
        List<DrawableActivity> activities = this.getAllDrawableActivities();
        for (DrawableActivity drawableObject : activities) {
            this.flowElements.add(drawableObject);
        }
    }

    @Override
    public Iterator<DrawableFlowElement> iterator() {
        return this.flowElements.iterator();
    }

    public void removeObject(DrawableFlowElement dObj) {
        this.flowElements.remove(dObj);
    }

    public int size() {
        return this.flowElements.size();
    }

    public <T> T as(Class<T> type) {
        Object result = null;
        if (this.isSingle()) {
            result = this.getSingle().as(type);
        }
        if (ModelObjectSelection.class.isAssignableFrom(type)) {
            result = type.cast(this.asModelObjectSelection());
        }
        return (T)result;
    }

    public <T> List<T> asList(Class<T> type) {
        return null;
    }

    public DrawableFlowElement[] toArray() {
        return this.flowElements.toArray(new DrawableFlowElement[this.flowElements.size()]);
    }

    public void unSelectTransitions() {
        Iterator<DrawableFlowElement> it = this.flowElements.iterator();
        while (it.hasNext()) {
            DrawableFlowElement obj = it.next();
            if (!(obj instanceof DrawableSequenceFlow)) continue;
            it.remove();
        }
    }

    public void unSelectLanes() {
        Iterator<DrawableFlowElement> it = this.flowElements.iterator();
        while (it.hasNext()) {
            DrawableFlowElement obj = it.next();
            if (!(obj instanceof DrawableLaneName) && !(obj instanceof DrawableLaneColumn)) continue;
            it.remove();
        }
    }

    public List<FlowElement> getAllModelObjects() {
        ArrayList<FlowElement> result = new ArrayList<FlowElement>();
        List<DrawableFlowElement> list = this.getAllObjects();
        for (DrawableFlowElement drawableFlowElement : list) {
            result.add((FlowElement)drawableFlowElement.getModelObject());
        }
        return result;
    }

    public Collection<SequenceFlow> getIncomingTransitions() {
        ArrayList<SequenceFlow> result = new ArrayList<SequenceFlow>();
        List<FlowNode> list = this.getAllActivities();
        for (FlowNode node : list) {
            Sequence incomingTransitions = ModelUtils.getIncomingSequenceFlows((FlowNode)node);
            for (SequenceFlow incomingTransition : incomingTransitions) {
                if (result.contains(incomingTransition)) continue;
                result.add(incomingTransition);
            }
        }
        return result;
    }

    public Collection<SequenceFlow> getOutgoingTransitions() {
        ArrayList<SequenceFlow> result = new ArrayList<SequenceFlow>();
        List<FlowNode> list = this.getAllActivities();
        for (FlowNode node : list) {
            Sequence transitions = ModelUtils.getOutgoingSequenceFlows((FlowNode)node);
            for (SequenceFlow incomingTransition : transitions) {
                if (list.contains(incomingTransition.getTarget())) continue;
                result.add(incomingTransition);
            }
        }
        return result;
    }

    public boolean isText() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.process == null ? 0 : this.process.hashCode());
        result = 31 * result + (this.drawRectangle ? 1231 : 1237);
        result = 31 * result + (this.flowElements == null ? 0 : this.flowElements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessSelection other = (ProcessSelection)obj;
        if (this.process == null ? other.process != null : !this.process.equals(other.process)) {
            return false;
        }
        if (this.drawRectangle != other.drawRectangle) {
            return false;
        }
        return !(this.flowElements == null ? other.flowElements != null : !this.flowElements.equals(other.flowElements));
    }

    @NotNull
    public DrawableFlowElement getSingle() {
        if (this.flowElements.isEmpty()) {
            throw new IllegalStateException("Attempting to getSingle an empty selection!");
        }
        return this.flowElements.get(0);
    }
}

