/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawableFlowElementImpl;
import oracle.bpm.draw.DrawableLaneColumn;
import oracle.bpm.draw.DrawableLaneName;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.processes.Lane;
import org.jetbrains.annotations.NotNull;

public class DrawableRole
extends DrawableFlowElementImpl<Lane> {
    private DrawableLaneName name;
    private DrawableLaneColumn columm;
    private Color background;

    protected DrawableRole(@NotNull Drawable container, @NotNull Lane lane) {
        super(container, lane, DesignerLayer.LANE_NAME);
    }

    @Override
    public void add() {
        super.add();
        this.name.add();
        this.columm.add();
    }

    @Override
    public void remove() {
        super.remove();
        this.name.remove();
        this.columm.remove();
    }

    @Override
    public boolean contains(int x, int y) {
        Point offset = this.getBounds().getOrigin();
        return this.name.contains(x -= offset.getX(), y -= offset.getY()) || this.columm.contains(x, y);
    }

    public void refreshChildren() {
        this.name.refresh();
        this.columm.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.setWidth(2000);
        this.setHeight(((Lane)this.getModelObject()).getSize());
        this.setLocation(new Point(this.getWidth() / 2, ((Lane)this.getModelObject()).getOffset() + this.getHeight() / 2));
        this.setBackground(Color.valueOf((int)((Lane)this.getModelObject()).getBackgroundColor(), (boolean)true));
        this.name.refresh();
        this.columm.refresh();
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    @Override
    public boolean isHidden() {
        return ((Lane)this.getModelObject()).getSize() == 1 || this.getContext().isRenderFlowOnly();
    }

    public DrawableLaneName getName() {
        return this.name;
    }

    public DrawableLaneColumn getColumm() {
        return this.columm;
    }
}

