/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.DrawableLabel;
import oracle.bpm.diagram.draw.DrawableLabelable;
import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElementImpl;
import oracle.bpm.draw.DrawableFlowElementLabel;
import oracle.bpm.draw.DrawableNodeContainer;
import oracle.bpm.draw.DrawableSequenceFlow;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.renderer.FlowElementImageRenderer;
import oracle.bpm.draw.renderer.FlowElementRenderer;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.Measurement;
import org.jetbrains.annotations.NotNull;

public class DrawableMeasurement
extends DrawableFlowElementImpl<Measurement>
implements DrawableLabelable {
    private GeneralPath arrow = new GeneralPath();
    private final FlowElementRenderer flowElementRenderer;
    private DrawableLabel<Measurement> label;

    protected DrawableMeasurement(@NotNull DrawableNodeContainer<?> container, @NotNull Measurement measurement) {
        super(container, measurement, DesignerLayer.MEASUREMENT);
        this.label = DrawableFlowElementLabel.create(container, this);
        this.flowElementRenderer = this.createFlowElementRenderer();
        this.attachRenderer(this.flowElementRenderer);
    }

    @Override
    @NotNull
    public DrawableNodeContainer getContainer() {
        return (DrawableNodeContainer)super.getContainer();
    }

    @Override
    public final void draw() {
        this.drawArrowToSequenceFlow();
        super.draw();
    }

    @Override
    public final boolean contains(int x, int y) {
        return this.flowElementRenderer.contains(x, y);
    }

    @Override
    public boolean intersects(@NotNull Rectangle rectangle) {
        return super.intersects(rectangle) || this.intersectsArrow(rectangle);
    }

    @Override
    public void add() {
        super.add();
        this.label.add();
    }

    @Override
    public void remove() {
        this.label.remove();
        super.remove();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.setLocation(((Measurement)this.getModelObject()).getLocation());
        Dimension size = this.flowElementRenderer.getRenderDimension();
        this.setWidth(size.getWidth());
        this.setHeight(size.getHeight());
    }

    @Override
    public DrawableLabel getLabel() {
        return this.label;
    }

    protected FlowElementImageRenderer createFlowElementRenderer() {
        return FlowElementImageRenderer.create(this);
    }

    private boolean intersectsArrow(@NotNull Rectangle rectangle) {
        rectangle = this.getContext().scale(rectangle);
        return this.arrow.intersects(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    private void drawArrow(Point pFrom, Point2D pTo) {
        double alfa;
        DrawContext context = this.getContext();
        double toX = pTo.getX();
        double fromX = pFrom.getX();
        double toY = pTo.getY();
        double fromY = pFrom.getY();
        double dx = toX - fromX;
        double dy = toY - fromY;
        if (dx == 0.0 && dy == 0.0) {
            return;
        }
        if (dx == 0.0) {
            alfa = dy > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        } else if (dy == 0.0) {
            alfa = dx > 0.0 ? 0.0 : Math.PI;
        } else {
            alfa = Math.atan(dy / dx);
            if (dx < 0.0) {
                alfa += Math.PI;
            }
        }
        double beta = alfa + 1.5707963267948966;
        double gamma = alfa - 1.5707963267948966;
        double dv = context.scale(3);
        Point2D.Double v1 = new Point2D.Double(dv * Math.cos(beta) + fromX, dv * Math.sin(beta) + fromY);
        Point2D.Double v2 = new Point2D.Double(dv * Math.cos(gamma) + fromX, dv * Math.sin(gamma) + fromY);
        Graphics g = context.getGraphics();
        Font prevFont = g.getFont();
        Font font = prevFont.scale(context.getScale());
        g.setFont(this.isShowSelection() ? font.bold() : font.plain());
        this.arrow = new GeneralPath();
        this.arrow.moveTo((float)toX, (float)pTo.getY());
        this.arrow.lineTo((float)((Point2D)v1).getX(), (float)((Point2D)v1).getY());
        this.arrow.lineTo((float)((Point2D)v2).getX(), (float)((Point2D)v2).getY());
        this.arrow.closePath();
        g.setFont(prevFont);
        g.draw((Shape)this.arrow);
        g.fill((Shape)this.arrow);
    }

    private void drawArrowToSequenceFlow() {
        if (((Measurement)this.getModelObject()).getTransition() != null) {
            DrawableSequenceFlow sequenceFlow = (DrawableSequenceFlow)this.getContainer().asDrawable((FlowElement)((Measurement)this.getModelObject()).getTransition());
            DrawContext context = this.getContext();
            Point from = context.scale(this.getLocation());
            Graphics graphics = context.getGraphics();
            Color original = graphics.getForeground();
            graphics.setForeground(Color.GRAY.brighter());
            AntialiasingMode mode = graphics.getAntialiasing();
            graphics.setAntialiasing(AntialiasingMode.ON);
            sequenceFlow.refresh();
            Point2D to = sequenceFlow.getPathPoint(0.5);
            this.drawArrow(from, new Point2D.Double((double)context.getScale() * to.getX(), (double)context.getScale() * to.getY()));
            graphics.setForeground(original);
            graphics.setAntialiasing(mode);
        }
    }
}

