/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.draw;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElementImpl;
import oracle.bpm.draw.DrawableLaneColumn;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.Stroke;
import oracle.bpm.draw.renderer.GraphicsMemento;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.features.CustomizedImageFeature;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.ui.CustomImageHelper;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class DrawableLaneName
extends DrawableFlowElementImpl<Lane>
implements Renderer {
    private DrawableLaneColumn column = new DrawableLaneColumn(this);
    public static final int LANE_NAME_SIZE = 25;
    private static Map<String, Image> roleLabels;

    DrawableLaneName(@NotNull Drawable container, @NotNull Lane lane) {
        super(container, lane, DesignerLayer.LANE_NAME);
        this.attachRenderer(this);
    }

    @Override
    public void add() {
        super.add();
        this.column.add();
    }

    @Override
    public void remove() {
        super.remove();
        this.column.remove();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.refreshLaneName();
        this.column.refresh();
    }

    @Override
    public boolean intersects(@NotNull Rectangle rectangle) {
        this.refreshLaneName();
        Point origin = this.getBounds().getOrigin();
        return rectangle.intersects(origin.getX(), origin.getY(), 20000, this.getHeight());
    }

    public String getDisplayName() {
        String result = ((Lane)this.getModelObject()).isAutomatic() ? ProjectMsg.AUTOMATIC_HANDLER_ROLE.getString() : ((Lane)this.getModelObject()).getDefaultLabel();
        if (result == null) {
            result = ((Lane)this.getModelObject()).getName();
        }
        return result;
    }

    @Override
    public void render() {
        DrawContext context = this.getContext();
        Graphics g = context.getGraphics();
        if (g == null) {
            return;
        }
        CustomizedImageFeature feature = (CustomizedImageFeature)((Lane)this.getModelObject()).getFeature(CustomizedImageFeature.class);
        String image = feature.getValue();
        Image icon = null;
        if (image != null) {
            try {
                icon = CustomImageHelper.getCustomImage((String)image);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        GraphicsMemento memento = GraphicsMemento.create(g);
        float scale = context.getScale();
        g.setFont(this.getFont());
        String titleToShow = this.getDisplayName();
        String key = titleToShow + scale + this.isShowSelection();
        Color fontColor = this.getFontColor();
        Color fontSelectedColor = this.getFontSelectedColor();
        key = key + fontColor.toString() + fontSelectedColor.toString();
        Image label = DrawableLaneName.getRoleLabels().get(key);
        if (label == null) {
            label = this.buildLabelImage(key, titleToShow);
        }
        if (((Lane)this.getModelObject()).getName() != null) {
            Color color = this.isShowSelection() ? this.getRoleBackground().darker() : Color.LIGHT_GRAY;
            g.setForeground(color);
            this.drawRoleRectangle();
            g.setForeground(this.getRoleFontColor());
            if (!((Lane)this.getModelObject()).isAutomatic() && label != null) {
                this.drawLabelImage(fontSelectedColor, label);
            }
        }
        if (icon != null) {
            this.drawIcon(icon);
        }
        memento.restore(g);
    }

    public DrawableLaneColumn getColumn() {
        return this.column;
    }

    protected Color getRoleBackground() {
        return Color.LIGHT_GRAY;
    }

    private static Map<String, Image> getRoleLabels() {
        if (roleLabels == null) {
            roleLabels = new HashMap<String, Image>();
        }
        return roleLabels;
    }

    private void refreshLaneName() {
        this.setWidth(25);
        this.setHeight(((Lane)this.getModelObject()).getSize());
        Point location = new Point(this.getWidth() / 2, this.getHeight() / 2);
        int offset = this.getContext().scale(this.getContainer().getAbsoluteOffset().getX());
        int deltaX = this.getContext().isPrinting() ? 0 : Math.max(0, this.getContext().unscale(this.getContext().getDeltaX()) - offset);
        this.setLocation(location.translate(deltaX, ((Lane)this.getModelObject()).getOffset()));
    }

    private Font getFont() {
        DrawContext context = this.getContext();
        Font font = context.getTheme().getLaneFont(this.isShowSelection());
        return context.scale(font);
    }

    private Color getFontColor() {
        return this.getContext().getTheme().getRoleFontColor();
    }

    private Color getFontSelectedColor() {
        return this.getContext().getTheme().getSelectedRoleFontColor();
    }

    private void draw3DSq(int x, int y, int width, int height) {
        Graphics g = this.getContext().getGraphics();
        Rectangle rectangle = new Rectangle(x, y, width, height - 1);
        Color color = this.isShowSelection() ? Color.FUEGO_LIGHT_BLUE.darker() : (!((Lane)this.getModelObject()).isAutomatic() ? Color.FUEGO_LIGHT_BLUE : Color.LIGHT_GRAY);
        g.setForeground(color);
        g.fill(rectangle);
        g.setStroke(Stroke.ONE_SOLID);
        g.setForeground(Color.BLACK);
        g.draw(rectangle);
    }

    private Color getRoleFontColor() {
        Color color = this.isShowSelection() ? this.getFontSelectedColor() : this.getFontColor();
        return color;
    }

    private void drawIcon(Image icon) {
        DrawContext context = this.getContext();
        Rectangle bounds = context.scale(this.getBounds().shrink(2));
        Graphics graphics = context.getGraphics();
        icon = icon.getScaledToWidthInstance(bounds.getWidth());
        Rectangle newBounds = Rectangle.valueOf((Point)bounds.getOrigin(), (int)icon.getWidth(), (int)icon.getHeight());
        graphics.drawImage(icon, newBounds);
    }

    private void drawRoleRectangle() {
        DrawContext context = this.getContext();
        Rectangle bounds = context.scale(this.getBounds());
        this.draw3DSq(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    private void drawLabelImage(Color fontSelectedColor, Image label) {
        DrawContext context = this.getContext();
        Graphics graphics = context.getGraphics();
        if (this.isShowSelection()) {
            graphics.setForeground(fontSelectedColor);
        }
        UiContainer imageObserver = context.getContainer();
        Point location = context.scale(this.getBounds().getCenter()).translate(-label.getWidth() / 2, -label.getHeight() / 2);
        graphics.drawImage(label, location.getX(), location.getY(), (UiComponent)imageObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image buildLabelImage(String key, String titleToShow) {
        DrawContext context = this.getContext();
        Graphics g = context.getGraphics();
        Font f = this.getFont();
        FontMetrics fm1 = g.getFontMetrics(f);
        int labelImageWidth = fm1.stringWidth(titleToShow);
        int labelImageHeight = fm1.getMaxAscent() + fm1.getMaxDescent();
        Image result = null;
        if (labelImageHeight != 0 && labelImageWidth != 0) {
            BufferedImage image = new BufferedImage(labelImageWidth, labelImageHeight, 2);
            result = Image.create((int)image.getWidth(), (int)image.getHeight());
            if (result == null) {
                try {
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice gs = ge.getDefaultScreenDevice();
                    GraphicsConfiguration gc = gs.getDefaultConfiguration();
                    BufferedImage image1 = gc.createCompatibleImage(labelImageWidth, labelImageHeight, 1);
                    result = Image.create((int)image1.getWidth(), (int)image1.getHeight());
                }
                catch (UnsupportedOperationException e) {
                    return null;
                }
            }
            Graphics g2 = result.getGraphics();
            try {
                g2.setFont(f);
                if (this.isShowSelection()) {
                    g2.setForeground(Color.FUEGO_LIGHT_BLUE.darker());
                } else {
                    g2.setForeground(Color.FUEGO_LIGHT_BLUE);
                }
                Rectangle rectangle = new Rectangle(0, 0, labelImageWidth, labelImageHeight);
                g2.fill(rectangle);
                g2.draw(rectangle);
                g2.setForeground(Color.BLACK);
                g2.drawString(titleToShow, 0, fm1.getMaxAscent());
            }
            finally {
                g2.dispose();
            }
            result = result.rotate90cc();
            roleLabels.put(key, result);
        }
        return result;
    }
}

